/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import io.papermc.paper.chat.ChatRenderer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigOption;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class MorphChatRenderer
extends MorphPluginObject
implements ChatRenderer {
    private Component message;
    private Component messageRevealed;
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphManager;
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    private FormattableMessage formattable = null;
    private static boolean incompatableChat = false;

    public MorphChatRenderer(FormattableMessage formattable) {
        if (formattable != null) {
            this.formattable = formattable;
        }
    }

    @NotNull
    public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component incomingMessage, @NotNull Audience viewer) {
        if (this.formattable == null) {
            ConfigOption<String> option = ConfigOptions.CHAT_OVERRIDE_DEFAULT_PATTERN;
            this.formattable = new FormattableMessage(this.plugin, this.config.getOrDefault(option));
        }
        if (this.message == null) {
            DisguiseState state = this.morphManager.getDisguiseStateFor(source);
            if (state != null) {
                sourceDisplayName = state.getServerDisplay();
            }
            try {
                this.message = this.buildMessage(sourceDisplayName, incomingMessage, source);
                this.messageRevealed = this.buildMessage(sourceDisplayName.append((Component)Component.text((String)("(" + source.getName() + ")"))), incomingMessage, source);
            }
            catch (Throwable t) {
                this.logger.error("Error occurred while formatting message", t);
                this.message = this.message == null ? Component.empty() : this.message;
                Object object = this.messageRevealed = this.messageRevealed == null ? Component.empty() : this.messageRevealed;
            }
        }
        if (!(viewer instanceof Permissible)) {
            if (!incompatableChat) {
                this.logger.warn("It seems that this server is using a chat plugin that doesn't compatible with us.");
                this.logger.warn("ChatOverride will not work for this situation and will always show the revealed message.");
                this.logger.warn("");
                this.logger.warn("If you believe this is an error, please open an issue on our GitHub repository!");
            }
            incompatableChat = true;
            return this.messageRevealed;
        }
        Permissible permissible = (Permissible)viewer;
        return permissible.hasPermission("feathermorph.chatoverride.reveal") ? this.messageRevealed : this.message;
    }

    private Component buildMessage(Component displayName, Component msg, Player player) {
        String locale = MessageUtils.getLocale(player);
        return new FormattableMessage(FeatherMorphMain.getMorphNameSpace(), this.formattable.getKey(), this.formattable.getDefaultString()).resolve("who", displayName).resolve("message", msg).createComponent();
    }
}

