/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.ArmorStandPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.AxolotlPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.CatPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.ChickenPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.CopperGolemPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.CowPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.CreeperPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.EnderDragonPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.FallbackPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.FoxPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.FrogPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.GoatPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.GuardianPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.HappyGhastPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.HoglinPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.HorsePropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.LlamaPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.MannequinPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.MooshroomPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.PandaPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.ParrotPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.PhantomPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.PigPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.PlayerPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.PropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.RabbitPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.SheepPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.ShulkerPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.SlimeMagmaPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.SnowGolemPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.TraderLlamaPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.TropicalFishPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.VillagerPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.WolfPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZoglinPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZombiePropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZombieVillagerPropertyCollection;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class DisguiseProperties {
    public static final DisguiseProperties INSTANCE = new DisguiseProperties();
    private static final Logger log = LoggerFactory.getLogger(DisguiseProperties.class);
    private final Map<EntityType, PropertyCollection<?>> handlerMap = new ConcurrentHashMap();
    private final Map<String, SingleProperty<?>> idPropertyMap = new ConcurrentHashMap();
    private volatile PropertyCollection<?> defaultProperties;

    public boolean register(SingleProperty<?> property) {
        if (this.idPropertyMap.containsKey(property.identifier())) {
            return false;
        }
        this.idPropertyMap.put(property.identifier(), property);
        return true;
    }

    @Nullable
    public SingleProperty<?> lookup(String identifier) {
        return this.idPropertyMap.getOrDefault(identifier, null);
    }

    public Optional<SingleProperty<?>> lookupOptional(String identifier) {
        return Optional.ofNullable(this.lookup(identifier));
    }

    public List<SingleProperty<?>> lookupRange(Collection<String> ids) {
        ObjectArrayList list = new ObjectArrayList();
        ids.forEach(arg_0 -> this.lambda$lookupRange$0((List)list, arg_0));
        return list;
    }

    public void loadBuiltin() {
        this.defaultProperties = new FallbackPropertyCollection();
        this.registerCollection(EntityType.FROG, new FrogPropertyCollection());
        this.registerCollection(EntityType.CAT, new CatPropertyCollection());
        this.registerCollection(EntityType.AXOLOTL, new AxolotlPropertyCollection());
        this.registerCollection(EntityType.FOX, new FoxPropertyCollection());
        this.registerCollection(EntityType.GOAT, new GoatPropertyCollection());
        this.registerCollection(EntityType.MOOSHROOM, new MooshroomPropertyCollection());
        this.registerCollection(EntityType.PARROT, new ParrotPropertyCollection());
        this.registerCollection(EntityType.RABBIT, new RabbitPropertyCollection());
        this.registerCollection(EntityType.WOLF, new WolfPropertyCollection());
        this.registerCollection(EntityType.LLAMA, new LlamaPropertyCollection());
        this.registerCollection(EntityType.HORSE, new HorsePropertyCollection());
        this.registerCollection(EntityType.PANDA, new PandaPropertyCollection());
        this.registerCollection(EntityType.VILLAGER, new VillagerPropertyCollection());
        this.registerCollection(EntityType.ZOMBIE_VILLAGER, new ZombieVillagerPropertyCollection());
        this.registerCollection(EntityType.ARMOR_STAND, new ArmorStandPropertyCollection());
        this.registerCollection(EntityType.CREEPER, new CreeperPropertyCollection());
        this.registerCollection(EntityType.PIG, new PigPropertyCollection());
        this.registerCollection(EntityType.COW, new CowPropertyCollection());
        this.registerCollection(EntityType.CHICKEN, new ChickenPropertyCollection());
        this.registerCollection(EntityType.ENDER_DRAGON, new EnderDragonPropertyCollection());
        this.registerCollection(EntityType.HAPPY_GHAST, new HappyGhastPropertyCollection());
        this.registerCollection(EntityType.PLAYER, new PlayerPropertyCollection());
        SlimeMagmaPropertyCollection slimeMagmaProperties = new SlimeMagmaPropertyCollection();
        this.registerCollection(EntityType.SLIME, slimeMagmaProperties);
        this.registerCollection(EntityType.MAGMA_CUBE, slimeMagmaProperties);
        this.registerCollection(EntityType.SHULKER, new ShulkerPropertyCollection());
        this.registerCollection(EntityType.TRADER_LLAMA, new TraderLlamaPropertyCollection());
        this.registerCollection(EntityType.PHANTOM, new PhantomPropertyCollection());
        this.registerCollection(EntityType.SHEEP, new SheepPropertyCollection());
        this.registerCollection(EntityType.SNOW_GOLEM, new SnowGolemPropertyCollection());
        this.registerCollection(EntityType.TROPICAL_FISH, new TropicalFishPropertyCollection());
        this.registerCollection(EntityType.HOGLIN, new HoglinPropertyCollection());
        this.registerCollection(EntityType.ZOGLIN, new ZoglinPropertyCollection());
        this.registerCollection(EntityType.ZOMBIE, new ZombiePropertyCollection());
        this.registerCollection(EntityType.GUARDIAN, new GuardianPropertyCollection());
        this.registerCollection(EntityType.ELDER_GUARDIAN, new GuardianPropertyCollection());
        this.registerCollection(EntityType.MANNEQUIN, new MannequinPropertyCollection());
        this.registerCollection(EntityType.COPPER_GOLEM, new CopperGolemPropertyCollection());
    }

    public Map<EntityType, PropertyCollection<?>> getAllCollections() {
        return new Object2ObjectOpenHashMap(this.handlerMap);
    }

    public List<SingleProperty<?>> getAllProperties() {
        return this.idPropertyMap.values().stream().toList();
    }

    public void registerCollection(EntityType type, PropertyCollection<?> properties) {
        if (this.handlerMap.containsKey(type)) {
            throw new IllegalArgumentException("Already contains properties setup for type " + String.valueOf(type));
        }
        this.handlerMap.put(type, properties);
        properties.getRegisteredProperties().values().forEach(this::register);
    }

    public <X> X getCollectionOrThrow(Class<X> expectedClass) {
        PropertyCollection find = this.handlerMap.values().stream().filter(expectedClass::isInstance).findFirst().orElse(null);
        if (find == null) {
            throw new NullDependencyException("Can't find '%s' in registered properties.".formatted(expectedClass));
        }
        return (X)find;
    }

    @NotNull
    public <X> X getCollectionOrThrow(EntityType type, Class<X> expetedClass) {
        PropertyCollection<?> raw = this.getCollection(type);
        if (!expetedClass.isInstance(raw)) {
            throw new NullDependencyException("Can't get disguise properties for type '%s', expected '%s' but got '%s'".formatted(type, expetedClass, raw.getClass()));
        }
        return (X)raw;
    }

    @NotNull
    public PropertyCollection<?> getCollection(EntityType type) {
        return this.handlerMap.getOrDefault(type, Objects.requireNonNull(this.defaultProperties, "Bad implementation! Please report this bug to authors on our GitHub!"));
    }

    private /* synthetic */ void lambda$lookupRange$0(List list, String id) {
        SingleProperty<?> property = this.lookup(id);
        if (property != null) {
            list.add(property);
        }
    }
}

