/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.ISupportDiffs;
import xyz.nifeather.morph.misc.actions.BiConsumerActions;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidationException;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.ValidationFlag;
import xyz.nifeather.morph.misc.disguiseProperty.values.PropertyCollection;

public class PropertyHandler {
    private final Map<SingleProperty<?>, Object> propertyMap = new ConcurrentHashMap();
    private final Map<String, SingleProperty<?>> validProperties = new ConcurrentHashMap();
    protected final BiConsumerActions<SingleProperty<?>, Object> actions = new BiConsumerActions();

    public <X> void hookOnPropertyWrite(BiConsumer<SingleProperty<X>, X> consumer) {
        this.actions.hook(consumer);
    }

    public Map<String, String> toNetworkProperties() throws ParseErrorException, ExecutionErrorException {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        try {
            for (Map.Entry<SingleProperty<?>, Object> entry : this.propertyMap.entrySet()) {
                SingleProperty<?> property = entry.getKey();
                if (property.hideFromClient()) continue;
                Object value = entry.getValue();
                map.put(property.id(), property.forValue(value));
            }
        }
        catch (ParseErrorException e) {
            throw e;
        }
        catch (Throwable t) {
            throw ExecutionErrorException.forMethod("PropertyHandler#toNetworkProperties").withMessage("Unhandled exception.").causedBy(t).create();
        }
        return map;
    }

    public void registerFromPropertyCollection(PropertyCollection<?> properties) {
        this.validProperties.putAll(properties.getRegisteredProperties());
    }

    public void addProperty(SingleProperty<?> property) {
        this.validProperties.put(property.id(), property);
    }

    public void updateFromPropertiesInput(Map<String, String> input, Player inputSource, EnumSet<ValidationFlag> validationFlags) throws ParseErrorException, PropertyValidationException {
        ConcurrentHashMap<SingleProperty, Object> parsedResults = new ConcurrentHashMap<SingleProperty, Object>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            Object val;
            String key = entry.getKey();
            String value = entry.getValue();
            SingleProperty property = this.validProperties.getOrDefault(key, null);
            if (property == null || (val = property.forInput(value).orElse(null)) == null) continue;
            property.validateInput(val, inputSource, validationFlags);
            parsedResults.put(property, val);
        }
        parsedResults.forEach(this::writeGeneric);
    }

    public void reset() {
        this.validProperties.clear();
        this.clearProperties();
    }

    public void clearProperties() {
        this.propertyMap.clear();
    }

    private void writeGeneric(SingleProperty<?> property, Object value) {
        if (!property.type().isInstance(value)) {
            throw new IllegalArgumentException("Incompatible value for id '%s', excepted for '%s', but got '%s'".formatted(property.id(), property.defaultVal().getClass(), value.getClass()));
        }
        this.set(property, value);
    }

    public <X> void set(SingleProperty<X> property, @NotNull X value) throws NullPointerException {
        if (!this.validProperties.containsKey(property.id())) {
            FeatherMorphMain.getInstance().getSLF4JLogger().warn("The given property '%s' is not registered in propertyHandler".formatted(property.id()));
            return;
        }
        Objects.requireNonNull(value, "Null values are not accepted");
        Object existing = this.getOptional(property).orElse(null);
        if (!value.equals(existing)) {
            X diffIfPossible;
            if (existing instanceof ISupportDiffs) {
                ISupportDiffs existingDiff = existing;
                diffIfPossible = existingDiff.diff(value);
            } else {
                diffIfPossible = value;
            }
            this.propertyMap.put(property, value);
            this.actions.invoke(BiConsumerActions.pair(property, diffIfPossible));
        }
    }

    public boolean contains(SingleProperty<?> property) {
        return this.propertyMap.containsKey(property);
    }

    public boolean contains(String propertyName) {
        return this.propertyMap.keySet().stream().anyMatch(sp -> sp.id().equals(propertyName));
    }

    @NotNull
    public <X> X get(SingleProperty<X> property) {
        return this.getOr(property, property.defaultVal());
    }

    public <X> Optional<X> getOptional(SingleProperty<X> property) {
        return Optional.ofNullable(this.getOr(property, null));
    }

    @Nullable
    @Contract(value="_, null -> _; _, !null -> !null")
    public <X> X getOr(SingleProperty<X> property, X defaultVal) {
        return (X)this.propertyMap.getOrDefault(property, defaultVal);
    }

    @Nullable
    @Contract(value="_, null -> _; _, !null -> !null")
    public <X> X getOr(String propertyName, @Nullable X defaultVal) {
        SingleProperty property = this.validProperties.getOrDefault(propertyName, null);
        if (property == null) {
            return defaultVal;
        }
        return this.getOr(property, defaultVal);
    }

    public Map<SingleProperty<?>, ?> getAll() {
        return new Object2ObjectArrayMap(this.propertyMap);
    }

    public void copyTo(PropertyHandler other) {
        other.validProperties.putAll(this.validProperties);
        this.propertyMap.forEach((k, v) -> other.set((SingleProperty)k, (Object)v));
    }

    public void dispose() {
        this.actions.clear();
    }
}

