/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidations;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.PropertyCollection;

public abstract class BaseLivingEntityPropertyCollection<E extends Entity>
extends PropertyCollection<E> {
    public final SingleProperty<Boolean> CUSTOM_NAME_VISIBLE = SingleProperty.builder("entity/custom_name_visible", Boolean.class, false).withInputHandle(InputHandles::readBooleanRelaxed).withOutputHandle(OutputHandles::writeBoolean).withSuggestions("true", "false").build();
    public final SingleProperty<Integer> STUCKED_ARROWS = SingleProperty.builder("entity/stucked_arrows", Integer.class, 0).withInputHandle(this::readArrows).withOutputHandle(OutputHandles::writeInteger).build();
    public final SingleProperty<Component> CUSTOM_NAME = this.createCustomNameProperty();
    public final SingleProperty<DisguiseEquipment> EQUIPMENT = SingleProperty.builder("entity/equipment", DisguiseEquipment.class, DisguiseEquipment.empty()).withInputHandle(InputHandles::readEquipment).withOutputHandle(OutputHandles::writeEquipment).withValidator(PropertyValidations::validateEquipment).hideFromUserInput(true).build();
    public final SingleProperty<Boolean> DISPLAY_DISGUISE_EQUIPMENT = SingleProperty.builder("entity/display_disguise_equipment", false).withInputHandle(InputHandles::readBooleanStrict).withOutputHandle(OutputHandles::writeBoolean).build();

    protected SingleProperty<Component> createCustomNameProperty() {
        return SingleProperty.builder("entity/custom_name", Component.class, Component.empty()).withInputHandle(InputHandles::readComponentAny).withOutputHandle(OutputHandles::writeAdventureComponentJSON).withValidator(PropertyValidations::validateCustomTextPermission).build();
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull E targetEntity) {
        if (!meta.getEntityType().equals((Object)targetEntity.getType())) {
            return;
        }
        propertyHandler.set(this.CUSTOM_NAME_VISIBLE, targetEntity.isCustomNameVisible());
        Component entityCustomName = targetEntity.customName();
        if (entityCustomName != null) {
            propertyHandler.set(this.CUSTOM_NAME, entityCustomName);
        }
    }

    private Optional<Integer> readArrows(String propertyName, String string) throws ParseErrorException {
        Integer val = InputHandles.readInteger(propertyName, string).orElseThrow(() -> new ParseErrorException(propertyName, "readArrows: Unable to parse arrows"));
        InputHandles.throwIfOutOfBounds(propertyName, val, 0, 100);
        return Optional.of(val);
    }

    public BaseLivingEntityPropertyCollection() {
        this.registerSingle(this.CUSTOM_NAME, this.CUSTOM_NAME_VISIBLE, this.STUCKED_ARROWS, this.EQUIPMENT, this.DISPLAY_DISGUISE_EQUIPMENT);
    }
}

