/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.world.level.block.WeatheringCopper;
import org.bukkit.craftbukkit.entity.CraftCopperGolem;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;

public class CopperGolemPropertyCollection
extends BaseLivingEntityPropertyCollection<CopperGolem> {
    public final SingleProperty<WeatherState> WEATHER_STATE = SingleProperty.builder("copper_golem/weather_state", WeatherState.UNAFFECTED).withInputHandle(this::readWeatherState).withOutputHandle(OutputHandles::writeEnum).withSuggestions(Arrays.stream(WeatherState.values()).map(ws -> ws.name().toLowerCase()).toList()).build();

    private Optional<WeatherState> readWeatherState(String propertyName, String input) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])WeatherState.values(), (String)propertyName, (String)input);
    }

    public CopperGolemPropertyCollection() {
        this.registerSingle((SingleProperty<?>)this.WEATHER_STATE);
    }

    @Override
    @Nullable
    protected CopperGolem tryCastEntity(@Nullable Entity targetEntity) {
        CopperGolem copperGolem;
        return targetEntity instanceof CopperGolem ? (copperGolem = (CopperGolem)targetEntity) : null;
    }

    @Override
    public void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull CopperGolem copperGolem) {
        super.setupPropertiesFromEntity(meta, propertyHandler, copperGolem);
        WeatheringCopper.WeatherState nmsWeatherState = ((CraftCopperGolem)copperGolem).getHandle().getWeatherState();
        WeatherState bukkitWeatherState = switch (nmsWeatherState) {
            default -> throw new MatchException(null, null);
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatherState.WEATHERED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatherState.OXIDIZED;
        };
        propertyHandler.set(this.WEATHER_STATE, bukkitWeatherState);
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }

    public static enum WeatherState {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

