/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class GoatPropertyCollection
extends BaseLivingEntityPropertyCollection<Goat> {
    public final SingleProperty<Boolean> HAS_LEFT_HORN = SingleProperty.builder("goat/has_left_horn", true).withInputHandle(InputHandles::readBooleanRelaxed).withOutputHandle(OutputHandles::writeBoolean).withRandom((Boolean[])new Boolean[]{true, true, true, false}).withSuggestions("false", "true").build();
    public final SingleProperty<Boolean> HAS_RIGHT_HORN = SingleProperty.builder("goat/has_right_horn", true).withInputHandle(InputHandles::readBooleanRelaxed).withOutputHandle(OutputHandles::writeBoolean).withRandom((Boolean[])new Boolean[]{true, true, true, false}).withSuggestions("false", "true").build();

    public GoatPropertyCollection() {
        this.registerSingle(this.HAS_LEFT_HORN, this.HAS_RIGHT_HORN);
    }

    @Override
    @Nullable
    protected Goat tryCastEntity(@Nullable Entity targetEntity) {
        Goat goat;
        return targetEntity instanceof Goat ? (goat = (Goat)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Goat goat) {
        super.setupPropertiesFromEntity(meta, propertyHandler, goat);
        propertyHandler.set(this.HAS_LEFT_HORN, goat.hasLeftHorn());
        propertyHandler.set(this.HAS_RIGHT_HORN, goat.hasRightHorn());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.HAS_RIGHT_HORN, DisguiseUtils.pick(this.HAS_RIGHT_HORN.randomValues()));
        propertyHandler.set(this.HAS_LEFT_HORN, DisguiseUtils.pick(this.HAS_LEFT_HORN.randomValues()));
    }
}

