/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import com.mojang.authlib.GameProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mannequin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidations;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.GameProfileUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class MannequinPropertyCollection
extends BaseLivingEntityPropertyCollection<Mannequin> {
    public final SingleProperty<Component> NPC_DESCRIPTION = SingleProperty.builder("mannequin/description", Component.class, Component.empty()).withInputHandle(InputHandles::readComponentAny).withOutputHandle(OutputHandles::writeAdventureComponentJSON).withValidator(PropertyValidations::validateCustomTextPermission).build();
    public final SingleProperty<Boolean> HIDE_DESCRIPTION = SingleProperty.builder("mannequin/hide_description", false).withInputHandle(InputHandles::readBooleanRelaxed).withOutputHandle(OutputHandles::writeBoolean).withValidator(PropertyValidations::validateCustomTextPermission).withSuggestions("true", "false").build();
    public final SingleProperty<Boolean> IMMOVABLE = SingleProperty.builder("mannequin/immovable", false).withInputHandle(InputHandles::immediateException).withOutputHandle(OutputHandles::writeBoolean).withValidator(PropertyValidations::validateCustomTextPermission).withSuggestions("true", "false").build();
    public final SingleProperty<ResolvableProfile> SKIN = SingleProperty.builder("mannequin/skin", ResolvableProfile.class, GameProfileUtils.asResolvableProfile(new GameProfile(Uuids.NIL_UUID, "notset"))).withInputHandle(InputHandles::readResolvableSkinInput).withOutputHandle(OutputHandles::writeResolvableProfileAny).withValidator(PropertyValidations::validateMannequinCustomSkinPermission).build();

    public MannequinPropertyCollection() {
        this.registerSingle(this.NPC_DESCRIPTION, this.HIDE_DESCRIPTION, this.SKIN, this.IMMOVABLE);
    }

    @Override
    @Nullable
    protected Mannequin tryCastEntity(@Nullable Entity targetEntity) {
        Mannequin mannequin;
        return targetEntity instanceof Mannequin ? (mannequin = (Mannequin)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Mannequin targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.SKIN, targetEntity.getProfile());
        Component description = targetEntity.getDescription();
        if (description != null) {
            propertyHandler.set(this.NPC_DESCRIPTION, description);
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.CUSTOM_NAME_VISIBLE, true);
    }
}

