/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Panda;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class PandaPropertyCollection
extends BaseLivingEntityPropertyCollection<Panda> {
    private final Map<String, Panda.Gene> geneMap = new ConcurrentHashMap<String, Panda.Gene>();
    public final SingleProperty<Panda.Gene> MAIN_GENE;
    public final SingleProperty<Panda.Gene> HIDDEN_GENE;

    private void initMap() {
        for (Panda.Gene gene : Panda.Gene.values()) {
            this.geneMap.put(gene.name().toLowerCase(), gene);
        }
    }

    private Optional<Panda.Gene> readGene(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Panda.Gene.values(), (String)propertyName, (String)string);
    }

    public PandaPropertyCollection() {
        this.initMap();
        this.MAIN_GENE = SingleProperty.builder("panda/main_gene", Panda.Gene.NORMAL).withInputHandle(this::readGene).withOutputHandle(OutputHandles::writeEnum).withRandom((Panda.Gene[])Panda.Gene.values()).withSuggestions(this.geneMap.keySet()).build();
        this.HIDDEN_GENE = SingleProperty.builder("panda/hidden_gene", Panda.Gene.NORMAL).withInputHandle(this::readGene).withOutputHandle(OutputHandles::writeEnum).withRandom((Panda.Gene[])Panda.Gene.values()).withSuggestions(this.geneMap.keySet()).build();
        this.registerSingle(this.MAIN_GENE, this.HIDDEN_GENE);
    }

    @Override
    @Nullable
    protected Panda tryCastEntity(@Nullable Entity targetEntity) {
        Panda panda;
        return targetEntity instanceof Panda ? (panda = (Panda)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Panda targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.MAIN_GENE, targetEntity.getMainGene());
        propertyHandler.set(this.HIDDEN_GENE, targetEntity.getHiddenGene());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.MAIN_GENE, DisguiseUtils.pick(this.MAIN_GENE.randomValues()));
        propertyHandler.set(this.HIDDEN_GENE, DisguiseUtils.pick(this.HIDDEN_GENE.randomValues()));
    }
}

