/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.messages.strings.ExceptionStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidations;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.GameProfileUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class PlayerPropertyCollection
extends BaseLivingEntityPropertyCollection<Player> {
    public final SingleProperty<MainHandStatus> MAIN_HAND = SingleProperty.builder("player/main_hand", MainHandStatus.NOTSET).withInputHandle(this::readHand).withOutputHandle(OutputHandles::writeEnum).withSuggestions("left", "right").build();
    public final SingleProperty<GameProfile> SKIN = SingleProperty.builder("player/skin", GameProfile.class, new GameProfile(Uuids.NIL_UUID, "unknown")).withInputHandle(InputHandles::readGameProfile).withOutputHandle(OutputHandles::writeGameProfile).hideFromUserInput(true).withValidator(PropertyValidations::validatePlayerSkin).build();

    @Override
    protected SingleProperty<Component> createCustomNameProperty() {
        return SingleProperty.builder("entity/custom_name", Component.class, Component.empty()).withInputHandle(InputHandles::unsupported).withOutputHandle(OutputHandles::writeAdventureComponentJSON).withValidator(PropertyValidations::validateCustomTextPermission).build();
    }

    private Optional<MainHandStatus> readHand(String propertyName, String string) throws ParseErrorException {
        if (string.equalsIgnoreCase("notset")) {
            throw ParseErrorException.forProperty(propertyName).byMethod("readHand").withLocalizableMessage(ExceptionStrings.inputNotAllowed()).withMessage("This value is not allowed here!").create();
        }
        return InputHandles.readEnumNonNull((Enum[])MainHandStatus.values(), (String)propertyName, (String)string);
    }

    public PlayerPropertyCollection() {
        this.registerSingle(this.MAIN_HAND, this.SKIN);
    }

    @Override
    @Nullable
    protected Player tryCastEntity(@Nullable Entity targetEntity) {
        Player player;
        return targetEntity instanceof Player ? (player = (Player)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Player targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.MAIN_HAND, MainHandStatus.fromBukkitHand(targetEntity.getMainHand()));
        propertyHandler.set(this.STUCKED_ARROWS, targetEntity.getArrowsInBody());
        if (meta.playerDisguiseTargetName != null && meta.playerDisguiseTargetName.equalsIgnoreCase(targetEntity.getName())) {
            propertyHandler.set(this.SKIN, GameProfileUtils.convertPlayerProfile(targetEntity.getPlayerProfile()));
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }

    public static enum MainHandStatus {
        LEFT(MainHand.LEFT),
        RIGHT(MainHand.RIGHT),
        NOTSET(null);

        @Nullable
        public final MainHand bindingHand;

        private MainHandStatus(MainHand hand) {
            this.bindingHand = hand;
        }

        public static MainHandStatus fromBukkitHand(MainHand hand) {
            return hand == MainHand.LEFT ? LEFT : RIGHT;
        }

        @Nullable
        public MainHand toBukkitHand() {
            return this.bindingHand;
        }
    }
}

