/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Arrays;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Shulker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;

public class ShulkerPropertyCollection
extends BaseLivingEntityPropertyCollection<Shulker> {
    public final SingleProperty<DyeColor> DYE_COLOR = SingleProperty.builder("shulker/color", DyeColor.class, DyeColor.getByWoolData((byte)15)).withInputHandle(InputHandles::readDyeColor).withOutputHandle(OutputHandles::writeEnum).withSuggestions(Arrays.stream(DyeColor.values()).map(c -> c.name().toLowerCase()).toList()).build();

    public ShulkerPropertyCollection() {
        this.registerSingle((SingleProperty<?>)this.DYE_COLOR);
    }

    @Override
    @Nullable
    protected Shulker tryCastEntity(@Nullable Entity targetEntity) {
        Shulker shulker;
        return targetEntity instanceof Shulker ? (shulker = (Shulker)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Shulker targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        if (targetEntity.getColor() != null) {
            propertyHandler.set(this.DYE_COLOR, targetEntity.getColor());
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }
}

