/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TropicalFish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class TropicalFishPropertyCollection
extends BaseLivingEntityPropertyCollection<TropicalFish> {
    public final SingleProperty<DyeColor> BODY_COLOR;
    public final SingleProperty<DyeColor> PATTERN_COLOR;
    public final SingleProperty<TropicalFish.Pattern> PATTERN;

    private Optional<TropicalFish.Pattern> readPattern(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])TropicalFish.Pattern.values(), (String)propertyName, (String)string);
    }

    public TropicalFishPropertyCollection() {
        List<String> dyeColorInputs = Arrays.stream(DyeColor.values()).map(c -> c.name().toLowerCase()).toList();
        this.BODY_COLOR = SingleProperty.builder("tropical_fish/body_color", DyeColor.GREEN).withInputHandle(InputHandles::readDyeColor).withOutputHandle(OutputHandles::writeEnum).withRandom((DyeColor[])DyeColor.values()).withSuggestions(dyeColorInputs).build();
        this.PATTERN_COLOR = SingleProperty.builder("tropical_fish/pattern_color", DyeColor.BLACK).withInputHandle(InputHandles::readDyeColor).withOutputHandle(OutputHandles::writeEnum).withRandom((DyeColor[])DyeColor.values()).withSuggestions(dyeColorInputs).build();
        this.PATTERN = SingleProperty.builder("tropical_fish/pattern", TropicalFish.Pattern.BLOCKFISH).withInputHandle(this::readPattern).withOutputHandle(OutputHandles::writeEnum).withRandom((TropicalFish.Pattern[])TropicalFish.Pattern.values()).withSuggestions(Arrays.stream(TropicalFish.Pattern.values()).map(p -> p.name().toLowerCase()).toList()).build();
        this.registerSingle(this.BODY_COLOR, this.PATTERN_COLOR, this.PATTERN);
    }

    @Override
    @Nullable
    protected TropicalFish tryCastEntity(@Nullable Entity targetEntity) {
        TropicalFish tropicalFish;
        return targetEntity instanceof TropicalFish ? (tropicalFish = (TropicalFish)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull TropicalFish targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        DyeColor bodyColor = targetEntity.getBodyColor();
        DyeColor patternColor = targetEntity.getPatternColor();
        TropicalFish.Pattern pattern = targetEntity.getPattern();
        propertyHandler.set(this.PATTERN_COLOR, patternColor);
        propertyHandler.set(this.BODY_COLOR, bodyColor);
        propertyHandler.set(this.PATTERN, pattern);
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        DyeColor bodyColor = DisguiseUtils.pick(this.BODY_COLOR.randomValues());
        DyeColor patternColor = DisguiseUtils.pick(this.PATTERN_COLOR.randomValues());
        TropicalFish.Pattern pattern = DisguiseUtils.pick(this.PATTERN.randomValues());
        propertyHandler.set(this.BODY_COLOR, bodyColor);
        propertyHandler.set(this.PATTERN_COLOR, patternColor);
        propertyHandler.set(this.PATTERN, pattern);
    }
}

