/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wolf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class WolfPropertyCollection
extends BaseLivingEntityPropertyCollection<Wolf> {
    private final Map<String, Wolf.Variant> variantMap = new ConcurrentHashMap<String, Wolf.Variant>();
    public final SingleProperty<Wolf.Variant> VARIANT;
    public final SingleProperty<UUID> OWNER = SingleProperty.builder("wolf/owner", Uuids.NIL_UUID).withInputHandle(InputHandles::readUUID).withOutputHandle(OutputHandles::writeUUID).build();
    public final SingleProperty<DyeColor> COLLAR_COLOR;

    private void initMap() {
        for (Wolf.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.WOLF_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
    }

    public Optional<Wolf.Variant> readWolfVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.WOLF_VARIANT, propertyName, string);
    }

    public WolfPropertyCollection() {
        this.initMap();
        this.VARIANT = SingleProperty.builder("wolf/variant", Wolf.Variant.PALE).withInputHandle(this::readWolfVariant).withOutputHandle(OutputHandles::writeKeyed).withRandom(RegistryAccess.registryAccess().getRegistry(RegistryKey.WOLF_VARIANT).stream().toList()).withSuggestions(this.variantMap.keySet()).build();
        this.COLLAR_COLOR = SingleProperty.builder("wolf/collar_color", DyeColor.RED).withInputHandle(InputHandles::readDyeColor).withOutputHandle(OutputHandles::writeEnum).withSuggestions(Arrays.stream(DyeColor.values()).map(c -> c.name().toLowerCase()).toList()).build();
        this.registerSingle(this.VARIANT, this.OWNER, this.COLLAR_COLOR);
    }

    @Override
    @Nullable
    protected Wolf tryCastEntity(@Nullable Entity targetEntity) {
        Wolf wolf;
        return targetEntity instanceof Wolf ? (wolf = (Wolf)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Wolf targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.VARIANT, targetEntity.getVariant());
        propertyHandler.set(this.COLLAR_COLOR, targetEntity.getCollarColor());
        if (targetEntity.getOwnerUniqueId() != null) {
            propertyHandler.set(this.OWNER, targetEntity.getOwnerUniqueId());
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.randomValues()));
    }
}

