/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.gui;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.values.MannequinPropertyCollection;
import xyz.nifeather.morph.misc.disguiseProperty.values.PlayerPropertyCollection;
import xyz.nifeather.morph.misc.gui.ITextIconProvider;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;
import xyz.nifeather.morph.utilities.GameProfileUtils;

public class IconLookup {
    private static IconLookup instance;
    private final Map<String, ItemStack> registry = new ConcurrentHashMap<String, ItemStack>();
    private final List<ITextIconProvider> customComponentSupplier = ObjectLists.synchronize((ObjectList)new ObjectArrayList());
    private final ItemStack defaultItem = this.generateDefaultItem();
    @Nullable
    private Component fallbackTextIcon;

    public static IconLookup instance() {
        if (instance == null) {
            instance = new IconLookup();
        }
        return instance;
    }

    public IconLookup() {
        this.init();
    }

    protected Material getDisplayBaseMaterial() {
        return Material.SNOWBALL;
    }

    protected ItemStack generateDefaultItem() {
        ItemStack item = ItemStack.of((Material)this.getDisplayBaseMaterial());
        item.setData(DataComponentTypes.ITEM_MODEL, (Object)NamespacedKey.minecraft((String)"bedrock"));
        return item;
    }

    private void init() {
        for (EntityType value : EntityType.values()) {
            if (value == EntityType.PLAYER || value == EntityType.UNKNOWN || !value.isAlive()) continue;
            this.register(value);
        }
        this.register(EntityType.ARMOR_STAND, this.createIconForType(Material.ARMOR_STAND));
        this.register(EntityType.GIANT, this.createIconForType(Material.ZOMBIE_HEAD));
        this.register(EntityType.ILLUSIONER, this.createIconForType(Material.SPECTRAL_ARROW));
        this.register(EntityType.MANNEQUIN, this.createIconForType(Material.PLAYER_HEAD));
        this.registerComponentIconProvider(this::lookupGenericIcon);
    }

    public void registerComponentIconProvider(ITextIconProvider supplier) {
        this.customComponentSupplier.add(supplier);
    }

    private ItemStack createIconForEntityType(EntityType type) {
        String name = "%s_SPAWN_EGG".formatted(type.name().toUpperCase());
        Material match = Material.matchMaterial((String)name);
        if (match == null) {
            return this.defaultItem;
        }
        return this.createIconForType(match);
    }

    private void register(EntityType type) {
        this.register(type, this.createIconForEntityType(type));
    }

    private void register(EntityType type, ItemStack item) {
        item.editMeta(meta -> meta.setRarity(ItemRarity.COMMON));
        this.register(type.key().asString(), item);
    }

    private void register(EntityType type, Material material) {
        this.register(type, this.createIconForType(material));
    }

    private void register(String disguiseIdentifier, ItemStack stack) {
        this.registry.put(disguiseIdentifier, stack);
    }

    private ItemStack createIconForType(Material targetModelMaterial) {
        ItemStack materialItem = ItemStack.of((Material)targetModelMaterial);
        Key model = (Key)materialItem.getData(DataComponentTypes.ITEM_MODEL);
        Object modelKey = model == null ? targetModelMaterial.getKey() : model.key();
        ItemStack targetItem = ItemStack.of((Material)this.getDisplayBaseMaterial());
        targetItem.setData(DataComponentTypes.ITEM_MODEL, modelKey);
        return targetItem;
    }

    private ItemStack createIconForPlayer(String playerName) {
        ItemStack stack = this.createIconForType(Material.PLAYER_HEAD);
        stack.setData(DataComponentTypes.RARITY, (Object)ItemRarity.COMMON);
        PlayerSkinProvider.getInstance().fetchSkin(playerName).thenAccept(optional -> {
            if (optional.isEmpty()) {
                return;
            }
            stack.setData(DataComponentTypes.PROFILE, (Object)ResolvableProfile.resolvableProfile((PlayerProfile)new CraftPlayerProfile((GameProfile)optional.get())));
        });
        return stack;
    }

    public Component fallbackTextIcon() {
        if (this.fallbackTextIcon != null) {
            return this.fallbackTextIcon;
        }
        ResolvableProfile profile = (ResolvableProfile)ResolvableProfile.resolvableProfile().addProperty(new ProfileProperty("textures", "e3RleHR1cmVzOntTS0lOOnt1cmw6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTg5NmEzN2Y2NTU2MDkyNjVjMGZhYjM2ZWI0MzY1YjFiMWM1YTYwY2ViOWQzYWE5ZmVjMmJjNWU3NTZhY2QifX19")).build();
        ObjectComponent component = Component.object((ObjectContents)ObjectContents.playerHead((PlayerHeadObjectContents.SkinSource)profile));
        this.fallbackTextIcon = component;
        return component;
    }

    @NotNull
    public Component lookupTextIcon(String disguiseIdentifier) {
        for (ITextIconProvider stringOptionalFunction : this.customComponentSupplier) {
            Optional<Component> result = stringOptionalFunction.resolve(disguiseIdentifier);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return this.fallbackTextIcon();
    }

    public Optional<Component> getSkullIcon(Key modelKey) {
        String asString;
        switch (asString = modelKey.value()) {
            case "player_head": {
                PlayerHeadObjectContents.Builder head = ObjectContents.playerHead().texture(Key.key((String)"entity/player/wide/steve"));
                return Optional.of(Component.object((ObjectContents)head.build()));
            }
            case "zombie_head": {
                PlayerHeadObjectContents.Builder head = ObjectContents.playerHead().texture(Key.key((String)"entity/zombie/zombie"));
                return Optional.of(Component.object((ObjectContents)head.build()));
            }
        }
        return Optional.empty();
    }

    public Optional<Component> lookupGenericIcon(String disguiseIdentifier) {
        ItemStack item = this.lookup(disguiseIdentifier);
        ResolvableProfile profile = (ResolvableProfile)item.getData(DataComponentTypes.PROFILE);
        if (profile != null) {
            return Optional.of(Component.object((ObjectContents)ObjectContents.playerHead((PlayerHeadObjectContents.SkinSource)profile)));
        }
        Key model = (Key)item.getData(DataComponentTypes.ITEM_MODEL);
        if (model != null) {
            if (model.asString().contains("skull") || model.asString().contains("head")) {
                return this.getSkullIcon(model);
            }
            return Optional.of(Component.object((ObjectContents)ObjectContents.sprite((Key)Key.key((String)("item/" + model.value())))));
        }
        return Optional.empty();
    }

    public ItemStack lookup(String disguiseIdentifier) {
        ItemStack item = disguiseIdentifier.startsWith(DisguiseTypes.PLAYER.getNameSpace()) ? this.createIconForPlayer(DisguiseTypes.PLAYER.toStrippedId(disguiseIdentifier)) : this.registry.getOrDefault(disguiseIdentifier, this.defaultItem);
        return item;
    }

    public Component lookupDisguiseIcon(DisguiseState state) {
        PropertyHandler propertyHandler = state.disguisePropertyHandler();
        if (propertyHandler.contains("mannequin/skin")) {
            return this.lookupMannequinIcon(state);
        }
        if (propertyHandler.contains("player/skin")) {
            return this.lookupPlayerIcon(state);
        }
        return this.lookupTextIcon(state.getDisguiseIdentifier());
    }

    public Component lookupPlayerIcon(DisguiseState state) {
        PlayerPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(PlayerPropertyCollection.class);
        Optional<GameProfile> optional = state.disguisePropertyHandler().getOptional(properties.SKIN);
        return optional.map(skin -> Component.object((ObjectContents)ObjectContents.playerHead((PlayerHeadObjectContents.SkinSource)GameProfileUtils.asPlayerProfile(skin)))).orElse(IconLookup.instance().fallbackTextIcon());
    }

    public Component lookupMannequinIcon(DisguiseState state) {
        MannequinPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(MannequinPropertyCollection.class);
        Optional<ResolvableProfile> optional = state.disguisePropertyHandler().getOptional(properties.SKIN);
        return optional.map(skin -> Component.object((ObjectContents)ObjectContents.playerHead((PlayerHeadObjectContents.SkinSource)skin))).orElse(IconLookup.instance().fallbackTextIcon());
    }
}

