/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.integrations.placeholderapi;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.misc.integrations.placeholderapi.IPlaceholderProvider;
import xyz.nifeather.morph.misc.integrations.placeholderapi.builtin.AvaliableDisguisesProvider;
import xyz.nifeather.morph.misc.integrations.placeholderapi.builtin.StateNameProvider;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;

public class PlaceholderIntegration
extends PlaceholderExpansion {
    private static final List<IPlaceholderProvider> providers = new CopyOnWriteArrayList<IPlaceholderProvider>();
    private static final Logger log = LoggerFactory.getLogger(PlaceholderIntegration.class);
    private static final String defaultString = "invalid_placeholder";

    public PlaceholderIntegration(DependencyManager depManager) {
        this.addPlaceholders((List<IPlaceholderProvider>)ObjectArrayList.of((Object[])new IPlaceholderProvider[]{new StateNameProvider(), new AvaliableDisguisesProvider()}));
    }

    @NotNull
    public String getIdentifier() {
        return "feathermorph";
    }

    @NotNull
    public String getAuthor() {
        return "MATRIX-feather";
    }

    @NotNull
    public String getVersion() {
        return "1.5.0";
    }

    public boolean persist() {
        return true;
    }

    private void addPlaceholders(List<IPlaceholderProvider> providerList) {
        providerList.forEach(this::addPlaceholderProvider);
    }

    public boolean addPlaceholderProvider(IPlaceholderProvider provider) {
        if (providers.stream().anyMatch(p -> this.providerEquals((IPlaceholderProvider)p, provider))) {
            return false;
        }
        providers.addFirst(provider);
        return true;
    }

    private boolean providerEquals(IPlaceholderProvider source, IPlaceholderProvider target) {
        if (source == null || target == null) {
            return false;
        }
        return source.getPlaceholderIdentifier().equals(target.getPlaceholderIdentifier());
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String param) {
        if (player == null) {
            return defaultString;
        }
        String[] paramSpilt = (param = param.replaceFirst(this.getIdentifier() + "_", "")).split("_", 2);
        if (paramSpilt.length != 2) {
            return null;
        }
        IPlaceholderProvider provider = providers.stream().filter(p -> p.getPlaceholderIdentifier().equalsIgnoreCase(paramSpilt[0])).findFirst().orElse(null);
        if (provider == null) {
            return defaultString;
        }
        return provider.resolvePlaceholder(player, paramSpilt[1]);
    }
}

