/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.bukkit.GameMode;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public class MorphNearestAttackableGoal
extends Goal {
    private final Mob mob;
    private final MorphManager morphManager;
    @Nullable
    private LivingEntity targetedEntity;
    @Nullable
    private DisguiseState cachedTargetEntityState;

    public MorphNearestAttackableGoal(Mob mob, MorphManager morphManager) {
        this.mob = mob;
        this.morphManager = morphManager;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity newTarget;
        Tameable tameable;
        Mob mob = this.mob;
        if (mob instanceof Tameable && (tameable = (Tameable)mob).isTamed()) {
            return false;
        }
        if (this.targetedEntity != null) {
            return this.checkTargetEntity();
        }
        if (ThreadLocalRandom.current().nextInt(10) != 0) {
            return false;
        }
        this.targetedEntity = newTarget = this.findTarget();
        return newTarget != null;
    }

    private boolean checkTargetEntity() {
        LivingEntity target = this.targetedEntity;
        if (target == null) {
            return false;
        }
        if (!FoliaThreadUtils.isTickThreadFor((Entity)target)) {
            return false;
        }
        boolean cancelTarget = !this.mob.getWorld().equals((Object)target.getWorld());
        boolean bl = cancelTarget = cancelTarget || target.getLocation().distance(this.mob.getLocation()) > this.getFollowRange();
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            GameMode gamemode = targetPlayer.getGameMode();
            cancelTarget = cancelTarget || !targetPlayer.isOnline();
            cancelTarget = cancelTarget || gamemode.isInvulnerable();
            DisguiseState state = this.cachedTargetEntityState;
            cancelTarget = state != null && !state.disposed() ? cancelTarget || EntityTypeUtils.panicsFrom(this.mob.getType(), state.getEntityType()) : true;
        }
        return !cancelTarget;
    }

    private double getFollowRange() {
        AttributeInstance followRangeAttribute = this.mob.getAttribute(Attribute.FOLLOW_RANGE);
        return followRangeAttribute == null ? 16.0 : followRangeAttribute.getValue();
    }

    private LivingEntity findTarget() {
        double followRange = this.getFollowRange();
        List<Player> players = this.mob.getNearbyEntities(followRange, followRange, followRange).stream().filter(e -> {
            Player player;
            block3: {
                block2: {
                    if (!(e instanceof Player)) break block2;
                    player = (Player)e;
                    if (FoliaThreadUtils.isTickThreadFor(e)) break block3;
                }
                return false;
            }
            GameMode gamemode = player.getGameMode();
            return gamemode == GameMode.SURVIVAL || gamemode == GameMode.ADVENTURE;
        }).map(e -> (Player)e).toList();
        for (Player candidate : players) {
            DisguiseState state = this.morphManager.getDisguiseStateFor(candidate);
            if (state == null || !EntityTypeUtils.hostiles(this.mob.getType(), state.getEntityType())) continue;
            this.cachedTargetEntityState = state;
            return candidate;
        }
        return null;
    }

    public void start() {
        this.mob.setTarget(this.targetedEntity);
    }

    public void stop() {
        net.minecraft.world.entity.Mob mobHandle;
        LivingEntity target = this.targetedEntity;
        if (target == null) {
            return;
        }
        if (target.equals((Object)this.mob.getTarget())) {
            this.mob.setTarget(null);
        }
        if ((mobHandle = ((CraftMob)this.mob).getHandle()) instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)mobHandle;
            neutralMob.stopBeingAngry();
        }
        this.targetedEntity = null;
        this.cachedTargetEntityState = null;
    }
}

