/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.S2C.set;

import java.util.Map;
import xyz.nifeather.morph.network.BasicServerHandler;
import xyz.nifeather.morph.network.commands.S2C.set.AbstractS2CSetCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class S2CSetMobRevealCommand
extends AbstractS2CSetCommand<Float> {
    private final float val;

    public S2CSetMobRevealCommand(float val) {
        this.val = val;
    }

    public static S2CSetMobRevealCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        float value = Float.parseFloat(Asserts.getStringOrThrow(arguments, "val"));
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new RuntimeException("The value for S2CSetRevealingCommand should be finite");
        }
        return new S2CSetMobRevealCommand(value);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("val", Float.toString(this.val));
    }

    @Override
    public String getBaseName() {
        return "set_mob_reveal";
    }

    @Override
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onSetRevealing(this);
    }

    public float getValue() {
        return this.val;
    }
}

