/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.slave;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.network.multiInstance.IInstanceService;
import xyz.nifeather.morph.network.multiInstance.protocol.CommandRegistriesCopy;
import xyz.nifeather.morph.network.multiInstance.protocol.IMasterHandler;
import xyz.nifeather.morph.network.multiInstance.protocol.MIClientboundCommandRecord;
import xyz.nifeather.morph.network.multiInstance.protocol.MIServerboundCommandRecord;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;
import xyz.nifeather.morph.network.multiInstance.protocol.ProtocolLevel;
import xyz.nifeather.morph.network.multiInstance.protocol.SocketPlayerMeta;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SLoginCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SRequestSyncCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CDisconnectCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CLoginResponseCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CSwitchStateCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CSyncMetaCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CUpdateMetaCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.ProtocolState;
import xyz.nifeather.morph.network.multiInstance.slave.InstanceClient;
import xyz.nifeather.morph.network.multiInstance.slave.NetworkDataHolder;
import xyz.nifeather.morph.network.multiInstance.slave.VoidDataHolder;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class SlaveInstance
extends MorphPluginObject
implements IInstanceService,
IMasterHandler {
    @Nullable
    private InstanceClient client;
    private volatile CompletableFuture<Void> clientRunningFuture;
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    private final boolean startOnLoad;
    private final NetworkDataHolder playerDataHolder;
    private final Bindable<String> secret = new Bindable<Object>(null);
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphManager;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private final List<UUID> uuidsToRequest = ObjectLists.synchronize((ObjectList)new ObjectArrayList());
    private final Map<UUID, CompletableFuture<UUID>> playerSyncFutures = new ConcurrentHashMap<UUID, CompletableFuture<UUID>>();
    private final Bindable<ProtocolState> currentState = new Bindable<ProtocolState>(ProtocolState.NOT_CONNECTED);
    private final ProtocolLevel implementingLevel = ProtocolLevel.V4;
    @Nullable
    public Consumer<Integer> onClose;
    private final CommandRegistriesCopy registries = new CommandRegistriesCopy();

    public SlaveInstance(boolean startOnLoad) {
        this.startOnLoad = startOnLoad;
        this.playerDataHolder = new NetworkDataHolder(this);
        this.load();
    }

    public void resetDataStore() {
        if (Objects.equals(this.morphManager.getDataStore(), this.playerDataHolder)) {
            this.morphManager.setDataStore(null);
        }
    }

    private boolean stopClient() {
        if (this.client == null) {
            return true;
        }
        try {
            this.client.close(1001, "noRetry");
            this.client.dispose();
            this.client = null;
            this.clientRunningFuture.cancel(true);
            return true;
        }
        catch (Throwable t) {
            this.logSlaveError("Can't close client!", t);
            return false;
        }
    }

    private void logSlaveInfo(String message) {
        this.logger.info("[Slave@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logSlaveWarn(String message) {
        this.logger.warn("[Slave@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logSlaveError(String message, Throwable t) {
        this.logger.error("[Slave@%s] %s".formatted(Integer.toHexString(this.hashCode()), message), t);
    }

    private boolean prepareClient() {
        if (!this.stopClient()) {
            return false;
        }
        try {
            InstanceClient client;
            String rawAddr = this.config.getOrDefault(ConfigOptions.MASTER_ADDRESS);
            URI uri = URI.create("ws://" + rawAddr);
            this.client = client = new InstanceClient(uri, this.plugin, this);
            this.clientRunningFuture = CompletableFuture.runAsync(client);
            return true;
        }
        catch (Throwable t) {
            this.logSlaveError("Error occurred setting up client", t);
            return false;
        }
    }

    private void load() {
        this.logSlaveInfo("Preparing multi-instance client...");
        this.config.bind(this.secret, ConfigOptions.MASTER_SECRET);
        this.registries.registerS2C("deny", MIS2CDisconnectCommand::fromArguments).registerS2C("dmeta", MIS2CUpdateMetaCommand::fromArguments).registerS2C("r_login", MIS2CLoginResponseCommand::fromArguments).registerS2C("state", MIS2CSwitchStateCommand::fromArguments).registerS2C("sync_player_meta", MIS2CSyncMetaCommand::fromArguments);
        if (this.client != null) {
            return;
        }
        if (!this.startOnLoad) {
            return;
        }
        if (this.prepareClient()) {
            this.morphManager.setDataStore(new VoidDataHolder());
        } else {
            this.logSlaveWarn("Can't setup client, this instance will stay offline from the instance network!");
        }
        this.requestBatchLoop();
    }

    @Override
    public boolean stop() {
        return this.stopClient();
    }

    @ApiStatus.Internal
    public void sendCommand(MIC2SCommand command) {
        if (this.client == null) {
            throw new NullDependencyException("Null client!");
        }
        String cmd = this.gson.toJson((Object)MIServerboundCommandRecord.fromC2SCommand(command));
        if (this.client.isClosed()) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logSlaveInfo("[debug] We are sending WebSocket request while being offline?! trying to send '%s'".formatted(cmd));
            }
            return;
        }
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logSlaveInfo("WS Slave :: -> SERVER :: " + cmd);
        }
        this.client.send(cmd);
    }

    private synchronized void requestBatchLoop() {
        if (!this.uuidsToRequest.isEmpty()) {
            this.batchRequests();
        }
        this.addSchedule(this::requestBatchLoop, 2);
    }

    private void batchRequests() {
        if (this.client == null) {
            return;
        }
        ImmutableList list = ImmutableList.copyOf(this.uuidsToRequest);
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logger.info("Batching %s lookup requests".formatted(list.size()));
        }
        this.uuidsToRequest.clear();
        this.sendCommand(new MIC2SRequestSyncCommand((List<UUID>)list));
    }

    public synchronized CompletableFuture<UUID> requestData(UUID uuid) {
        CompletableFuture<UUID> future = this.getOrCreatePlayerFuture(uuid);
        this.requestData(List.of(uuid));
        return future;
    }

    public synchronized CompletableFuture<UUID> getOrCreatePlayerFuture(UUID uuid) {
        CompletableFuture existing = this.playerSyncFutures.getOrDefault(uuid, null);
        if (existing != null) {
            return existing;
        }
        CompletableFuture<UUID> newInstance = new CompletableFuture<UUID>();
        this.playerSyncFutures.put(uuid, newInstance);
        return newInstance;
    }

    public synchronized void requestData(@Unmodifiable List<UUID> uuid) {
        uuid.forEach(this::getOrCreatePlayerFuture);
        this.uuidsToRequest.addAll(uuid);
    }

    public boolean isOnline() {
        return this.client != null && this.client.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSyncMeta(MIS2CSyncMetaCommand command) {
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logSlaveInfo("Received data sync for %s entries".formatted(command.data().size()));
        }
        for (SocketPlayerMeta socketMeta : command.data()) {
            if (!socketMeta.isValid()) continue;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)Objects.requireNonNull(socketMeta.getBindingUuid(), "???"));
            PlayerMeta playerMeta = this.playerDataHolder.getOrCreatePlayerMeta(offlinePlayer);
            for (String identifier : socketMeta.getIdentifiers()) {
                DisguiseMeta disguiseMeta = this.playerDataHolder.getDisguiseMeta(identifier);
                if (disguiseMeta == null) continue;
                playerMeta.addDisguise(disguiseMeta);
            }
            SlaveInstance slaveInstance = this;
            synchronized (slaveInstance) {
                CompletableFuture<UUID> future = this.playerSyncFutures.remove(socketMeta.getBindingUuid());
                if (future != null) {
                    future.complete(socketMeta.getBindingUuid());
                }
            }
        }
    }

    @Override
    public void onUpdateMetaCommand(MIS2CUpdateMetaCommand metaCommand) {
        if (!this.currentState.get().loggedIn()) {
            this.logSlaveWarn("Bad server implementation? They are trying to sync meta before we login!");
            return;
        }
        SocketPlayerMeta socketMeta = metaCommand.getMeta();
        if (!socketMeta.isValid()) {
            this.logSlaveWarn("Bad server implementation? The meta is invalid!");
            return;
        }
        this.onReceivePlayerMetaUpdate(socketMeta);
    }

    private void onReceivePlayerMetaUpdate(SocketPlayerMeta socketMeta) {
        Operation operation = socketMeta.getOperation();
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)Objects.requireNonNull(socketMeta.getBindingUuid(), "???"));
        Player player = offlinePlayer.getPlayer();
        PlayerMeta playerMeta = this.morphManager.getPlayerMeta(offlinePlayer);
        if (operation == Operation.ADD_IF_ABSENT) {
            List<String> unlocked = playerMeta.getUnlockedDisguiseIdentifiers();
            ObjectArrayList diff = new ObjectArrayList();
            socketMeta.getIdentifiers().forEach(arg_0 -> this.lambda$onReceivePlayerMetaUpdate$0(unlocked, (List)diff, playerMeta, arg_0));
            if (player != null && !diff.isEmpty()) {
                if (diff.size() < 5) {
                    this.clientHandler.sendDiff((List<String>)diff, null, player);
                } else {
                    this.clientHandler.refreshPlayerClientMorphs(playerMeta.getUnlockedDisguiseIdentifiers(), player);
                }
            }
        } else if (operation == Operation.REMOVE) {
            ObjectArrayList diff = new ObjectArrayList();
            socketMeta.getIdentifiers().forEach(id -> {
                DisguiseMeta disguiseMeta = this.morphManager.getDisguiseMeta((String)id);
                playerMeta.removeDisguise(disguiseMeta);
            });
            if (player != null && !diff.isEmpty()) {
                if (diff.size() < 5) {
                    this.clientHandler.sendDiff(null, (List<String>)diff, player);
                } else {
                    this.clientHandler.refreshPlayerClientMorphs(playerMeta.getUnlockedDisguiseIdentifiers(), player);
                }
            }
        }
    }

    @Override
    public void onDisconnectCommand(MIS2CDisconnectCommand cDenyCommand) {
        this.stopClient();
    }

    @Override
    public void onLoginResponse(MIS2CLoginResponseCommand cLoginResultCommand) {
        if (this.currentState.get() != ProtocolState.LOGIN) {
            this.logSlaveWarn("Bad server implementation? They sent a login result at when we are not in a login process!");
            return;
        }
        if (!cLoginResultCommand.isAllowed()) {
            this.logSlaveWarn("Server refused the login");
            return;
        }
        this.logSlaveInfo("Done logging in! Setting up data holder");
        this.morphManager.setDataStore(this.playerDataHolder);
    }

    @Override
    public void onStateCommand(MIS2CSwitchStateCommand cStateCommand) {
        if (cStateCommand.getState() == ProtocolState.INVALID) {
            this.logSlaveWarn("Bad server implementation? The new session state is invalid!");
        }
        this.switchState(cStateCommand.getState());
    }

    private void switchState(ProtocolState newState) {
        this.logSlaveInfo("Client networking state switched to " + String.valueOf((Object)newState));
        this.currentState.set(newState);
    }

    @Override
    public void onConnectionOpen() {
        this.addSchedule(() -> this.sendCommand(new MIC2SLoginCommand(this.implementingLevel, this.secret.get())));
    }

    @Override
    public void onConnectionClose(int code) {
        if (this.onClose != null) {
            this.onClose.accept(code);
        }
    }

    @Override
    public void onClientError(Exception e, InstanceClient client) {
    }

    @Override
    public void onText(String text) {
        this.addSchedule(() -> this.onCommandRaw(text));
    }

    private void onCommandRaw(String raw) {
        try {
            MIClientboundCommandRecord decode = (MIClientboundCommandRecord)this.gson.fromJson(raw, MIClientboundCommandRecord.class);
            MIS2CCommand cmd = this.registries.createS2CCommand(decode.commandName(), decode.arguments());
            cmd.onCommand(this);
        }
        catch (Throwable t) {
            this.logSlaveWarn("Failed to handle message from master instance, stopping! (%s)".formatted(t.getMessage()));
            this.stopClient();
        }
    }

    private /* synthetic */ void lambda$onReceivePlayerMetaUpdate$0(List unlocked, List diff, PlayerMeta playerMeta, String str) {
        if (unlocked.contains(str)) {
            return;
        }
        diff.add(str);
        playerMeta.addDisguise(this.morphManager.getDisguiseMeta(str));
    }
}

