/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.server;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.Pair;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.minecraft.network.FriendlyByteBuf;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.api.networking.exceptions.ClientAPIMismatchException;
import xyz.nifeather.morph.api.networking.exceptions.ClientIntegrationDisabledException;
import xyz.nifeather.morph.api.networking.exceptions.PlayerRejectedException;
import xyz.nifeather.morph.api.networking.exceptions.ScheduleReconnectException;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.interfaces.IManageRequests;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.EmoteStrings;
import xyz.nifeather.morph.messages.strings.MorphStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ModNetworkingHelper;
import xyz.nifeather.morph.misc.MorphParameters;
import xyz.nifeather.morph.misc.PlayerWaitingHandler;
import xyz.nifeather.morph.network.BasicClientHandler;
import xyz.nifeather.morph.network.ConnectionState;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.InitializeState;
import xyz.nifeather.morph.network.PlayerOptions;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SActivateSkillCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SCommandRecord;
import xyz.nifeather.morph.network.commands.C2S.C2SExchangeRequestManagementCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SMorphCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestAnimationCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestInitialCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SSetSingleOptionCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SToggleSelfCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SUnmorphCommand;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.CommandRegistriesNew;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.commands.S2C.S2CReAuthCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSetCurrentCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUnAuthCommand;
import xyz.nifeather.morph.network.commands.S2C.query.QueryType;
import xyz.nifeather.morph.network.commands.S2C.query.S2CQueryCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetModifyBoundingBoxCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSelfViewingStatusCommand;
import xyz.nifeather.morph.network.server.LegacyClientHandler;
import xyz.nifeather.morph.network.server.MessageChannel;
import xyz.nifeather.morph.network.server.PlayerSession;
import xyz.nifeather.morph.network.server.handlers.ICommandPacketHandler;
import xyz.nifeather.morph.network.server.handlers.V3ProtocolHandler;
import xyz.nifeather.morph.network.server.handlers.results.CommandHandleResult;
import xyz.nifeather.morph.providers.animation.AnimationProvider;
import xyz.nifeather.morph.providers.animation.SingleAnimation;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class MorphClientHandler
extends MorphPluginObject
implements BasicClientHandler<Player> {
    private final Bindable<Boolean> allowClient = new Bindable<Boolean>(false);
    private final Bindable<Boolean> logInComingPackets = new Bindable<Boolean>(false);
    private final Bindable<Boolean> logOutGoingPackets = new Bindable<Boolean>(false);
    private final Bindable<Boolean> forceTargetVersion = new Bindable<Boolean>(false);
    private final LegacyClientHandler legacyClientHandler;
    private final Map<Player, ICommandPacketHandler> playerCommandHandlerMap = new ConcurrentHashMap<Player, ICommandPacketHandler>();
    public final int targetApiVersion = Constants.PROTOCOL_VERSION;
    public final int minimumApiVersion = 1;
    @Resolved
    private MorphManager manager;
    private final CommandRegistriesNew registries = new CommandRegistriesNew();
    private final Bindable<Boolean> modifyBoundingBoxes = new Bindable<Boolean>(false);
    private final Bindable<Boolean> useClientRenderer = new Bindable<Boolean>(false);
    private final Bindable<Boolean> debugOutput = new Bindable<Boolean>(false);
    public static final List<String> SERVER_FEATURE_FLAGS = List.of("1_21_3_packetbuf");
    private final PlayerWaitingHandler<Player> playerChannelPendingFutures = new PlayerWaitingHandler();
    private final PlayerWaitingHandler<Player> playerLoginPendingFutures = new PlayerWaitingHandler();
    private final PlayerWaitingHandler<Player> playerConnectionFutures = new PlayerWaitingHandler();
    private final Map<Player, PlayerSession> playerSessionMap = new ConcurrentHashMap<Player, PlayerSession>();
    private final AtomicBoolean scheduledReauthPlayers = new AtomicBoolean(false);
    @Resolved
    private IManageRequests requestManager;
    @Resolved
    private ModNetworkingHelper modNetworkingHelper;

    public MorphClientHandler() {
        this.legacyClientHandler = new LegacyClientHandler(this);
    }

    public boolean allowClient() {
        return this.allowClient.get();
    }

    public boolean logInComingPackets() {
        return this.logInComingPackets.get();
    }

    public void setProtocolHandlerFor(Player player, ICommandPacketHandler commandPacketHandler) {
        this.playerCommandHandlerMap.put(player, commandPacketHandler);
        this.onPlayerChannelRegister(player);
    }

    @Nullable
    public ICommandPacketHandler getProtocolHandler(Player player) {
        return this.playerCommandHandlerMap.getOrDefault(player, null);
    }

    @NotNull
    public ICommandPacketHandler getProtocolHandlerOrThrow(Player player) {
        return Objects.requireNonNull(this.getProtocolHandler(player), "Null Protocol Handler for player '%s', is everything good?".formatted(player));
    }

    @Override
    public boolean sendCommand(Player player, AbstractS2CCommand<?> basicS2CCommand) {
        if (this.getSession(player) == null) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.error("No Session for player " + player.getName() + ", not sending command: '%s'".formatted(basicS2CCommand.getBaseName()));
            }
            return false;
        }
        if (!player.isOnline() || this.getPlayerConnectionState(player).worseThan(InitializeState.HANDSHAKE)) {
            return false;
        }
        if (!this.plugin.isEnabled()) {
            return false;
        }
        this.getProtocolHandlerOrThrow(player).sendCommand(player, basicS2CCommand);
        return true;
    }

    public static void logPacket(boolean isOutGoingPacket, Player player, String channel, byte[] data) {
        MorphClientHandler.logPacket(isOutGoingPacket, player, channel, data, false);
    }

    public static void logPacket(boolean isOutGoingPacket, Player player, String channel, byte[] data, boolean isV1Proto) {
        Object msg;
        MorphClientHandler clientHandlerInstance = FeatherMorphAPI.instance().directAccess().clientHandler();
        if (isOutGoingPacket && !clientHandlerInstance.logOutGoingPackets.get().booleanValue()) {
            return;
        }
        if (!isOutGoingPacket && !clientHandlerInstance.logInComingPackets.get().booleanValue()) {
            return;
        }
        FriendlyByteBuf input = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            msg = isV1Proto ? new String(data, StandardCharsets.UTF_8) : input.readUtf();
        }
        catch (Throwable t) {
            msg = "<base64> " + Base64.getEncoder().encodeToString(data);
        }
        MorphClientHandler.logPacket(isOutGoingPacket, player, channel, (String)msg, data.length);
    }

    private static void logPacket(boolean isOutGoingPacket, Player player, String channel, String data, int size) {
        String arrow = isOutGoingPacket ? " -> " : " <- ";
        String builder = channel + arrow + player.getName() + " :: " + "'%s'".formatted(data) + " (\u2248 %s bytes)".formatted(size);
        FeatherMorphMain.getInstance().getSLF4JLogger().info(builder);
    }

    @Initializer
    private void load(FeatherMorphMain plugin, MorphConfigManager configManager) {
        this.registries.registerC2S("request_initial", C2SRequestInitialCommand::fromArguments).registerC2S("morph", C2SMorphCommand::fromArguments).registerC2S("skill", C2SActivateSkillCommand::fromArguments).registerC2S("set_single_option", C2SSetSingleOptionCommand::fromArguments).registerC2S("set_selfview_mode", C2SToggleSelfCommand::fromArguments).registerC2S("unmorph", C2SUnmorphCommand::fromArguments).registerC2S("manage_request", C2SExchangeRequestManagementCommand::fromArguments).registerC2S("request_animation", C2SRequestAnimationCommand::fromArguments);
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerIncomingPluginChannel((Plugin)plugin, MessageChannel.initializeChannelV3, this::handleInitializeV3);
        messenger.registerOutgoingPluginChannel((Plugin)plugin, MessageChannel.initializeChannelV3);
        messenger.registerIncomingPluginChannel((Plugin)plugin, MessageChannel.commandChannelV3, this::handleCommandV3);
        messenger.registerOutgoingPluginChannel((Plugin)plugin, MessageChannel.commandChannelV3);
        configManager.bind(this.allowClient, ConfigOptions.ALLOW_CLIENT);
        configManager.bind(this.forceTargetVersion, ConfigOptions.FORCE_TARGET_VERSION);
        configManager.bind(this.logInComingPackets, ConfigOptions.LOG_INCOMING_PACKETS);
        configManager.bind(this.logOutGoingPackets, ConfigOptions.LOG_OUTGOING_PACKETS);
        configManager.bind(this.modifyBoundingBoxes, ConfigOptions.MODIFY_BOUNDING_BOX);
        configManager.bind(this.useClientRenderer, ConfigOptions.USE_CLIENT_RENDERER);
        configManager.bind(this.debugOutput, ConfigOptions.DEBUG_OUTPUT);
        this.forceTargetVersion.onValueChanged((o, n) -> this.scheduleReAuthPlayers());
        this.modifyBoundingBoxes.onValueChanged((o, n) -> this.scheduleReAuthPlayers());
        this.useClientRenderer.onValueChanged((o, n) -> this.scheduleReAuthPlayers());
        this.allowClient.onValueChanged((o, n) -> {
            List<Player> players = this.featherMorph().getPlatform().onlinePlayersNative();
            if (n.booleanValue()) {
                players.forEach(this::disconnectThenReAuth);
            } else {
                players.forEach(p -> this.disconnect((Player)p, new ClientIntegrationDisabledException("Client integration has been disabled")));
            }
        });
    }

    public void onPlayerChannelRegister(Player player) {
        ICommandPacketHandler protocolHandler = this.getProtocolHandler(player);
        if (protocolHandler == null) {
            return;
        }
        Set channelList = player.getListeningPluginChannels();
        if (channelList.containsAll(protocolHandler.validChannels())) {
            this.playerChannelPendingFutures.completeFuture(player);
        }
    }

    @Deprecated(forRemoval=true, since="(yyyy-mm-dd) 2025-08-14")
    public CompletableFuture<Player> getPlayerPendingFuture(Player player) {
        return this.getPlayerChannelPendingFuture(player);
    }

    public CompletableFuture<Player> getPlayerChannelPendingFuture(Player player) {
        return this.playerChannelPendingFutures.getWaitingFuture(player);
    }

    public CompletableFuture<Player> getPlayerLoginPendingFuture(Player player) {
        return this.playerLoginPendingFutures.getWaitingFuture(player);
    }

    public CompletableFuture<Player> getPlayerConnectionFuture(Player player) {
        return this.playerConnectionFutures.getWaitingFuture(player);
    }

    public InitializeRespondV3 getInitializeRespond() {
        return new InitializeRespondV3(SERVER_FEATURE_FLAGS, this.targetApiVersion);
    }

    private void handleInitializeV3(@NotNull String channel, @NotNull Player player, byte @NotNull [] rawData) {
        MorphClientHandler.logPacket(false, player, channel, rawData);
        if (this.getProtocolHandler(player) != null) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.info("Received init message while '%s' have a ProtocolHandler, ignoring...".formatted(player.getName()));
            }
            return;
        }
        ClientInitializeRecordV3 handleResult = V3ProtocolHandler.V3_INSTANCE.handleInitializeData(player, rawData);
        if (!handleResult.handleSuccess()) {
            this.rejectPlayer(player);
            return;
        }
        this.logger.info("%s is using V3 packets, scheduling response".formatted(player.getName()));
        this.setProtocolHandlerFor(player, V3ProtocolHandler.V3_INSTANCE);
        this.getPlayerChannelPendingFuture(player).thenRun(() -> this.handleHandshakeMessage(V3ProtocolHandler.V3_INSTANCE, player, handleResult));
    }

    public void handleHandshakeMessage(ICommandPacketHandler commandPacketHandler, @NotNull Player player, @NotNull ClientInitializeRecordV3 clientInitializeRecord) {
        if (!this.allowClient.get().booleanValue() || this.getPlayerConnectionState(player).greaterThan(InitializeState.HANDSHAKE)) {
            return;
        }
        int clientVersion = clientInitializeRecord.apiVersion();
        int minimumApiVersion = this.minimumApiVersion;
        if (this.forceTargetVersion.get().booleanValue()) {
            minimumApiVersion = this.targetApiVersion;
        }
        if (clientVersion < minimumApiVersion || clientVersion > this.targetApiVersion) {
            String logginMsg = player.getName() + " joined with incompatible client API version: " + clientVersion + " (This server requires " + this.targetApiVersion + ")";
            this.disconnect(player, new ClientAPIMismatchException(logginMsg));
            this.logger.info(logginMsg);
            FormattableMessage msg = this.forceTargetVersion.get() != false ? MorphStrings.clientVersionMismatchKickString() : MorphStrings.clientVersionMismatchString();
            msg.resolve("minimum_version", (Component)Component.text((int)minimumApiVersion)).resolve("player_version", (Component)Component.text((int)clientVersion));
            if (this.forceTargetVersion.get().booleanValue()) {
                player.kick(msg.createComponent());
            } else {
                player.sendMessage(msg.createComponent());
            }
            return;
        }
        this.logger.info(player.getName() + " joined with API version " + clientVersion);
        PlayerSession session = this.createSession(player);
        session.clientFeatures.addAll(clientInitializeRecord.clientFeatures());
        session.options.clientApiVersion = clientInitializeRecord.apiVersion();
        session.initializeState = InitializeState.API_CHECKED;
        session.apiVersion = clientVersion;
        commandPacketHandler.sendInitializeRespond(player, this.getInitializeRespond());
    }

    private void handleCommandV3(@NotNull String channel, @NotNull Player player, byte @NotNull [] data) {
        this.handleCommandFromHandlerInternal(V3ProtocolHandler.V3_INSTANCE, channel, player, data);
    }

    @ApiStatus.Internal
    public void handleCommandFromHandlerInternal(ICommandPacketHandler protocolHandler, @NotNull String channel, @NotNull Player player, byte @NotNull [] data) {
        CommandHandleResult result;
        if (this.logInComingPackets.get().booleanValue()) {
            MorphClientHandler.logPacket(false, player, channel, data);
        }
        if (!(result = protocolHandler.handleCommandData(player, data)).success()) {
            this.logger.info("Failed to decode command from player '%s', rejecting...".formatted(player.getName()));
            this.rejectPlayer(player);
            return;
        }
        this.handleCommandInput(player, result.result());
    }

    public void handleCommandInput(Player player, C2SCommandRecord commandRecord) {
        AbstractC2SCommand<Player> command;
        if (!this.allowClient.get().booleanValue()) {
            return;
        }
        PlayerSession session = this.getSession(player);
        if (session == null || session.initializeState.worseThan(InitializeState.API_CHECKED)) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.info("Player %s sent command while not checked API version! ignoring...");
            }
            return;
        }
        try {
            command = this.registries.createC2SCommand(commandRecord.commandName(), commandRecord.arguments());
        }
        catch (Throwable t) {
            this.logger.warn("Failed to create command instance from '%s': %s".formatted(player, t.getMessage()));
            this.rejectPlayer(player);
            return;
        }
        command.setOwner(player);
        command.onCommand(this);
    }

    public boolean playerHasFeature(Player player, String feature) {
        PlayerSession session = this.getSession(player);
        if (session == null) {
            return false;
        }
        return session.clientFeatures.stream().anyMatch(s -> s.equals(feature));
    }

    private PlayerSession createSession(Player player) {
        PlayerSession cached = this.playerSessionMap.getOrDefault(player, null);
        if (cached != null) {
            return cached;
        }
        PlayerSession instance = PlayerSession.SessionBuilder.builder(player).build();
        this.playerSessionMap.put(player, instance);
        return instance;
    }

    @Nullable
    public PlayerSession getSession(Player player) {
        return this.playerSessionMap.getOrDefault(player, null);
    }

    public void refreshPlayerClientMorphs(List<String> identifiers, Player player) {
        if (!this.allowClient.get().booleanValue()) {
            return;
        }
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CQueryCommand(QueryType.SET, identifiers));
    }

    public void sendDiff(@Nullable List<String> addits, @Nullable List<String> removal, Player player) {
        if (!this.allowClient.get().booleanValue()) {
            return;
        }
        if (addits != null) {
            this.sendCommand(player, (AbstractS2CCommand<?>)new S2CQueryCommand(QueryType.ADD, addits));
        }
        if (removal != null) {
            this.sendCommand(player, (AbstractS2CCommand<?>)new S2CQueryCommand(QueryType.REMOVE, removal));
        }
    }

    public void updateCurrentIdentifier(Player player, String str) {
        if (!this.allowClient.get().booleanValue()) {
            return;
        }
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetCurrentCommand(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReAuthPlayers() {
        AtomicBoolean atomicBoolean = this.scheduledReauthPlayers;
        synchronized (atomicBoolean) {
            if (this.scheduledReauthPlayers.get()) {
                return;
            }
            this.scheduledReauthPlayers.set(true);
        }
        this.addSchedule(() -> {
            AtomicBoolean atomicBoolean = this.scheduledReauthPlayers;
            synchronized (atomicBoolean) {
                if (!this.scheduledReauthPlayers.get()) {
                    return;
                }
                this.scheduledReauthPlayers.set(false);
                this.featherMorph().getPlatform().onlinePlayersNative().forEach(this::disconnectThenReAuth);
            }
        });
    }

    public void rejectPlayer(Player player) {
        this.logger.info("Rejecting player " + player.getName());
        MessageUtils.send((CommandSender)player, MorphStrings.unsupportedClientBehavior());
        this.disconnect(player, new PlayerRejectedException("Player has been rejected because of bad client behavior"));
    }

    public void disconnectThenReAuth(Player player) {
        ICommandPacketHandler handler = this.getProtocolHandler(player);
        if (handler == null) {
            return;
        }
        this.disconnect(player, new ScheduleReconnectException("A reconnection has been scheduled"));
        this.onPlayerChannelRegister(player);
        handler.sendCommand(player, new S2CReAuthCommand());
    }

    public boolean isFutureClientProtocol(Player player, int version) {
        return this.getPlayerVersion(player) >= version;
    }

    public InitializeState getPlayerConnectionState(Player player) {
        PlayerSession session = this.getSession(player);
        if (session == null) {
            return InitializeState.NOT_CONNECTED;
        }
        return session.initializeState;
    }

    public boolean clientConnected(Player player) {
        return this.getPlayerConnectionState(player).greaterThan(InitializeState.NOT_CONNECTED);
    }

    public boolean clientInitialized(Player player) {
        PlayerSession session = this.getSession(player);
        if (session == null) {
            return false;
        }
        return session.initializeState == InitializeState.DONE;
    }

    @Nullable
    @Contract(value="_, false -> null; _, true -> !null")
    public PlayerOptions<Player> getPlayerOption(Player player, boolean createSessionIfNull) {
        PlayerSession session = this.getSession(player);
        if (session != null) {
            return session.options;
        }
        if (!createSessionIfNull) {
            return null;
        }
        return this.createSession((Player)player).options;
    }

    @Override
    @Nullable
    public PlayerOptions<Player> getPlayerOption(Player player) {
        PlayerSession session = this.getSession(player);
        if (session == null) {
            return null;
        }
        return session.options;
    }

    @NotNull
    public PlayerOptions<Player> getPlayerOptionOrThrow(Player player) {
        PlayerOptions<Player> options = this.getPlayerOption(player);
        if (options == null) {
            throw new NullPointerException("Operation required a non-null PlayerOptions.");
        }
        return options;
    }

    @Override
    public int getPlayerVersion(Player player) {
        PlayerSession session = this.getSession(player);
        if (session == null) {
            return -1;
        }
        return session.apiVersion;
    }

    @Override
    public InitializeState getInitializeState(Player player) {
        PlayerSession session = this.getSession(player);
        return session == null ? InitializeState.NOT_CONNECTED : session.initializeState;
    }

    @Override
    public boolean isPlayerInitialized(Player player) {
        return this.getInitializeState(player) == InitializeState.DONE;
    }

    @Override
    public boolean isPlayerConnected(Player player) {
        return this.getInitializeState(player).greaterThan(InitializeState.PENDING);
    }

    @Override
    public List<Player> getConnectedPlayers() {
        return this.playerSessionMap.keySet().stream().toList();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void disconnect(Player player) {
        this.disconnect(player, null);
    }

    public void disconnect(Player player, @Nullable Exception reason) {
        this.playerChannelPendingFutures.discard(player, reason);
        this.playerLoginPendingFutures.discard(player, reason);
        this.playerConnectionFutures.discard(player, reason);
        PlayerMeta playerConfig = this.manager.getPlayerMeta((OfflinePlayer)player);
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        if (state != null) {
            state.setServerSideSelfVisible(playerConfig.showDisguiseToSelf);
        }
        if (this.getSession(player) != null) {
            this.sendCommand(player, (AbstractS2CCommand<?>)new S2CUnAuthCommand());
        }
        this.playerCommandHandlerMap.remove(player);
        this.playerSessionMap.remove(player);
    }

    @Override
    public void onInitialCommand(C2SRequestInitialCommand c2SInitialCommand) {
        Player player = (Player)c2SInitialCommand.getOwner();
        if (this.clientInitialized(player)) {
            return;
        }
        PlayerSession session = this.getSession(player);
        if (session == null) {
            throw new NullDependencyException("Player session is NULL while we accepts their commands?!");
        }
        if (session.connectionState != ConnectionState.JOINED) {
            session.connectionState = ConnectionState.CONNECTING;
        }
        if (this.clientInitialized(player)) {
            return;
        }
        PlayerMeta config = this.manager.getPlayerMeta((OfflinePlayer)player);
        List<String> list = config.getUnlockedDisguiseIdentifiers();
        this.refreshPlayerClientMorphs(list, player);
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        if (state != null) {
            this.manager.refreshClientState(state);
        }
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSelfViewingStatusCommand(config.showDisguiseToSelf));
        this.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetModifyBoundingBoxCommand(this.modifyBoundingBoxes.get()));
        if (player.hasPermission("feathermorph.disguise_revealing")) {
            this.sendCommand(player, (AbstractS2CCommand<?>)this.manager.genMapCommand());
        }
        if (state != null) {
            state.getDisguiseWrapper().getBackend().onClientModInitialize(player, this, this.manager);
        }
        session.initializeState = InitializeState.DONE;
        this.playerLoginPendingFutures.completeFuture(player);
    }

    @Override
    public void onMorphCommand(C2SMorphCommand c2SMorphCommand) {
        Player player = (Player)c2SMorphCommand.getOwner();
        String id = c2SMorphCommand.identifier();
        if (id.isBlank()) {
            this.manager.tryQuickDisguise(player);
            return;
        }
        if (!this.manager.canMorph(player)) {
            return;
        }
        MorphParameters parameters = MorphParameters.create(player, id).setTargetedEntity(player.getTargetEntity(5)).setSource((CommandSender)player).withProperties(c2SMorphCommand.propertyInputs());
        this.manager.morph(parameters);
    }

    @Override
    public void onOptionCommand(C2SSetSingleOptionCommand c2SOptionCommand) {
        C2SSetSingleOptionCommand.ClientOptionEnum option = c2SOptionCommand.getOption();
        Player player = (Player)c2SOptionCommand.getOwner();
        switch (option) {
            case CLIENTVIEW: {
                boolean val = Boolean.parseBoolean(c2SOptionCommand.getValue());
                this.getPlayerOptionOrThrow(player).setClientSideSelfView(val);
                DisguiseState state = this.manager.getDisguiseStateFor(player);
                if (state == null) break;
                state.setServerSideSelfVisible(!val);
                break;
            }
            case HUD: {
                boolean val;
                this.getPlayerOptionOrThrow((Player)player).displayDisguiseOnHUD = val = Boolean.parseBoolean(c2SOptionCommand.getValue());
                if (val) break;
                player.sendActionBar((Component)Component.empty());
            }
        }
    }

    @Override
    public void onSkillCommand(C2SActivateSkillCommand c2SSkillCommand) {
        this.manager.executeDisguiseSkill((Player)c2SSkillCommand.getOwner());
    }

    @Override
    public void onToggleSelfCommand(C2SToggleSelfCommand c2SToggleSelfCommand) {
        Player player = (Player)c2SToggleSelfCommand.getOwner();
        PlayerOptions<Player> playerOption = this.getPlayerOptionOrThrow(player);
        PlayerMeta playerConfig = this.manager.getPlayerMeta((OfflinePlayer)player);
        switch (c2SToggleSelfCommand.getSelfViewMode()) {
            case ON: {
                if (playerConfig.showDisguiseToSelf) {
                    return;
                }
                this.manager.setSelfDisguiseVisible(player, true, true, false, false);
                break;
            }
            case OFF: {
                if (!playerConfig.showDisguiseToSelf) {
                    return;
                }
                this.manager.setSelfDisguiseVisible(player, false, true, false, false);
                break;
            }
            case CLIENT_ON: {
                playerOption.setClientSideSelfView(true);
                DisguiseState state = this.manager.getDisguiseStateFor(player);
                if (state == null) break;
                state.setServerSideSelfVisible(false);
                break;
            }
            case CLIENT_OFF: {
                playerOption.setClientSideSelfView(false);
                DisguiseState state = this.manager.getDisguiseStateFor(player);
                if (state == null) break;
                state.setServerSideSelfVisible(true);
            }
        }
    }

    @Override
    public void onUnmorphCommand(C2SUnmorphCommand c2SUnmorphCommand) {
        this.manager.unMorph((Player)c2SUnmorphCommand.getOwner());
    }

    @Override
    public void onRequestCommand(C2SExchangeRequestManagementCommand c2SRequestCommand) {
        Player player = (Player)c2SRequestCommand.getOwner();
        String target = c2SRequestCommand.targetRequestName;
        C2SExchangeRequestManagementCommand.Decision deceison = c2SRequestCommand.decision;
        if (target.equalsIgnoreCase("unknown") || deceison == C2SExchangeRequestManagementCommand.Decision.UNKNOWN) {
            this.logger.warn("Received an invalid request response");
            return;
        }
        Player targetPlayer = Bukkit.getPlayerExact((String)target);
        if (targetPlayer == null) {
            return;
        }
        if (deceison == C2SExchangeRequestManagementCommand.Decision.ACCEPT) {
            this.requestManager.acceptRequest(player, targetPlayer);
        } else {
            this.requestManager.denyRequest(player, targetPlayer);
        }
    }

    @Override
    public void onAnimationCommand(C2SRequestAnimationCommand c2SAnimationCommand) {
        Pair<List<SingleAnimation>, Boolean> sequencePair;
        Player player = (Player)c2SAnimationCommand.getOwner();
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        AnimationProvider animationProvider = state.getProvider().getAnimationProvider();
        String disguiseID = state.getDisguiseIdentifier();
        String animationID = c2SAnimationCommand.getAnimationId();
        if (!state.tryScheduleSequence(animationID, (List)(sequencePair = animationProvider.getAnimationSetFor(disguiseID).sequenceOf(animationID)).left(), (Boolean)sequencePair.right())) {
            MessageUtils.send((CommandSender)player, EmoteStrings.notAvailable());
        }
    }
}

