/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.providers.disguise;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.abilities.AbilityManager;
import xyz.nifeather.morph.abilities.IAbility;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.waypoint.DisguiseWaypointTransmitter;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.network.server.ServerSetEquipCommand;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.storage.skill.SkillAbilityConfigContainer;

public abstract class DefaultDisguiseProvider
extends DisguiseProvider {
    @Resolved
    private SkillManager skillHandler;
    @Resolved
    private AbilityManager abilityHandler;
    @Resolved
    private MorphClientHandler clientHandler;
    @NotNull
    public static final NamespacedKey WAYPOINT_TRANSMIT_MODIFIER_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:waypoint_transmit_modifier"));

    @Override
    @NotNull
    public DisguiseBackend<?, ?> getPreferredBackend() {
        return this.getMorphManager().getDefaultBackend();
    }

    @Override
    public boolean updateDisguise(Player player, DisguiseState state) {
        return true;
    }

    protected AttributeInstance acquireAttributeOrThrow(Player player, Attribute attribute) {
        return Objects.requireNonNull(player.getAttribute(attribute), "Player don't have a '%s' attribute, you might using a broken server implementation.".formatted(attribute.key().asString()));
    }

    protected void mutePlayerWaypoint(Player player) {
        AttributeInstance attribute = this.acquireAttributeOrThrow(player, Attribute.WAYPOINT_TRANSMIT_RANGE);
        if (attribute.getModifier((Key)WAYPOINT_TRANSMIT_MODIFIER_KEY) == null) {
            attribute.addTransientModifier(new AttributeModifier(WAYPOINT_TRANSMIT_MODIFIER_KEY, -1.0, AttributeModifier.Operation.ADD_SCALAR));
        }
    }

    protected void recoverPlayerWaypoint(Player player) {
        this.acquireAttributeOrThrow(player, Attribute.WAYPOINT_TRANSMIT_RANGE).removeModifier((Key)WAYPOINT_TRANSMIT_MODIFIER_KEY);
    }

    protected void enableDisguiseWaypoint(DisguiseState state) {
        DisguiseWaypointTransmitter disguiseWaypoint = state.waypointTransmitter();
        disguiseWaypoint.enabled(true);
    }

    public void disableDisguiseWaypoint(DisguiseState state) {
        DisguiseWaypointTransmitter disguiseWaypoint = state.waypointTransmitter();
        disguiseWaypoint.enabled(false);
    }

    @Override
    @NotNull
    public List<AbstractS2CCommand<?>> getInitialSyncCommands(DisguiseState state) {
        if (this.skillHandler.hasSpeficSkill(state.skillLookupIdentifier(), SkillNames.FAKE_EQUIP) && this.clientHandler.getPlayerVersion(state.getPlayer()) < Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            DisguiseEquipment eqiupment = state.getDisguiseEquipment();
            ObjectArrayList list = new ObjectArrayList();
            this.addIfPresents(eqiupment, list, EquipmentSlot.HAND);
            this.addIfPresents(eqiupment, list, EquipmentSlot.OFF_HAND);
            this.addIfPresents(eqiupment, list, EquipmentSlot.HEAD);
            this.addIfPresents(eqiupment, list, EquipmentSlot.CHEST);
            this.addIfPresents(eqiupment, list, EquipmentSlot.LEGS);
            this.addIfPresents(eqiupment, list, EquipmentSlot.FEET);
            return list;
        }
        return List.of();
    }

    private void addIfPresents(DisguiseEquipment equipment, ObjectArrayList<AbstractS2CCommand<?>> list, EquipmentSlot slot) {
        ItemStack item = equipment.getItem(slot);
        if (item.getType() != Material.AIR) {
            list.add((Object)new ServerSetEquipCommand(item, slot));
        }
    }

    @Override
    public void buildDisguise(DisguiseState state, @Nullable Entity targetEntity) throws ParseErrorException {
        List<IAbility<?>> abilities = this.abilityHandler.getAbilitiesFor(state.skillLookupIdentifier());
        state.getAbilityUpdater().setAbilities(abilities);
        Map<NamespacedKey, ISkillAbilityOption> abilityOptions = this.abilityHandler.getOptionsFor(state.skillLookupIdentifier());
        abilityOptions.forEach((id, config) -> state.getAbilityUpdater().setAbilityConfig(id.asString(), (ISkillAbilityOption)config));
        SkillAbilityConfigContainer config2 = this.skillHandler.getConfiguration(state.skillLookupIdentifier());
        if (config2 == null) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.warn("The skill lookup '{}' does not have a matching skill/ability configuration", (Object)state.skillLookupIdentifier());
            }
            return;
        }
        ISkill<?> skill = this.skillHandler.getSkill(config2.getSkillIdentifier().key().asString());
        Object option = this.skillHandler.lookupOptionFor(skill, state.skillLookupIdentifier());
        state.bindSkill(skill, option);
        state.setDefaultSkillCooldown(config2.getSkillCooldown());
    }
}

