/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.abilities.IAbility;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public abstract class MorphAbility<T extends ISkillAbilityOption>
extends MorphPluginObject
implements IAbility<T> {
    private final List<UUID> appliedPlayers = Collections.synchronizedList(new ObjectArrayList());

    protected boolean requireValidOption() {
        return false;
    }

    public boolean isPlayerApplied(Player player) {
        return this.isPlayerApplied(player.getUniqueId());
    }

    public boolean isPlayerApplied(UUID playerUUID) {
        return this.appliedPlayers.stream().anyMatch(uuid -> uuid.equals(playerUUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyToPlayer(Player player, DisguiseState state) {
        List<UUID> list = this.appliedPlayers;
        synchronized (list) {
            if (this.appliedPlayers.stream().anyMatch(uuid -> uuid.equals(player.getUniqueId()))) {
                return true;
            }
            this.appliedPlayers.add(player.getUniqueId());
        }
        if (!this.requireValidOption()) {
            return true;
        }
        T option = this.getOptionFor(state);
        if (option != null && option.isValid()) {
            return true;
        }
        this.logger.error("Disguise '%s' does not have a valid configuration for ability %s, not processing...".formatted(state.getDisguiseIdentifier(), this.getIdentifier()));
        List<UUID> list2 = this.appliedPlayers;
        synchronized (list2) {
            this.appliedPlayers.remove(player.getUniqueId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeFromPlayer(Player player, DisguiseState state) {
        List<UUID> list = this.appliedPlayers;
        synchronized (list) {
            this.appliedPlayers.remove(player.getUniqueId());
        }
        return true;
    }

    @Override
    public @Unmodifiable List<UUID> getAppliedPlayers() {
        return new ObjectArrayList(this.appliedPlayers);
    }

    @Nullable
    protected T getOptionFor(DisguiseState state) {
        return (T)((ISkillAbilityOption)state.getAbilityUpdater().lookupAbilityConfig(this.getIdentifier().asString(), this.optionHandler().getOptionClass()));
    }

    protected <R> R getOr(Supplier<R> value, Predicate<R> p, Supplier<R> fallbackValue) {
        R val = value.get();
        if (p.test(val)) {
            return val;
        }
        return fallbackValue.get();
    }
}

