/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.ExtraAirOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;

public class ExtraAirAbility
extends MorphAbility<ExtraAirOption> {
    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.EXTRA_AIR;
    }

    @Override
    public boolean applyToPlayer(Player player, DisguiseState state) {
        ExtraAirOption option = (ExtraAirOption)this.getOptionFor(state);
        if (option == null) {
            this.logger.error("No option set for %s under %s".formatted(this.getIdentifier(), state.getDisguiseIdentifier()));
            return false;
        }
        float airPercentage = (float)player.getRemainingAir() / (float)player.getMaximumAir();
        player.setMaximumAir(option.maxAir());
        int value = Math.round((float)player.getMaximumAir() * airPercentage);
        value = Math.clamp((long)value, 0, player.getMaximumAir());
        player.setRemainingAir(value);
        return super.applyToPlayer(player, state);
    }

    @Override
    public boolean revokeFromPlayer(Player player, DisguiseState state) {
        float airPercentage = (float)player.getRemainingAir() / (float)player.getMaximumAir();
        player.setMaximumAir(300);
        int value = Math.round((float)player.getMaximumAir() * airPercentage);
        value = Math.clamp((long)value, 0, player.getMaximumAir());
        player.setRemainingAir(value);
        return super.revokeFromPlayer(player, state);
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        return true;
    }

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<ExtraAirOption> optionHandler() {
        return ExtraAirOption.OPTION_HANDLER;
    }
}

