/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.impl.NoOpOptionAbility;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;

public class SnowyAbility
extends NoOpOptionAbility {
    private static final Map<Player, Stack<Object>> blockedPlayersMap = new ConcurrentHashMap<Player, Stack<Object>>();

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.SNOWY;
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        Location playerLocation = player.getLocation();
        Block block = playerLocation.getBlock();
        if (block.getType().isAir() && !SnowyAbility.playerBlocked(player) && block.canPlace(Material.SNOW.createBlockData()) && block.getTemperature() <= 0.95) {
            block.setType(Material.SNOW);
        }
        player.setFreezeTicks(0);
        if (playerLocation.getBlock().getTemperature() > 1.0) {
            player.setFireTicks(40);
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTookDamage(EntityDamageEvent e) {
        Player player;
        Entity entity = e.getEntity();
        if (entity instanceof Player && this.isPlayerApplied(player = (Player)entity) && e.getCause() == EntityDamageEvent.DamageCause.FREEZE) {
            e.setDamage(0.0);
        }
    }

    public static boolean playerBlocked(Player player) {
        Stack stack = blockedPlayersMap.getOrDefault(player, null);
        return stack != null && !stack.isEmpty();
    }

    public static void blockPlayer(Player player, Object requestSource) {
        Stack<Object> stack = blockedPlayersMap.getOrDefault(player, null);
        if (stack == null) {
            stack = new Stack<Object>();
            blockedPlayersMap.put(player, stack);
        }
        if (!stack.contains(requestSource)) {
            stack.push(requestSource);
        }
    }

    public static void unBlockPlayer(Player player, Object requestSource) {
        Stack stack = blockedPlayersMap.getOrDefault(player, new Stack());
        stack.remove(requestSource);
    }
}

