/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.options;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class ReduceDamageOption
implements ISkillAbilityOption {
    public static final ReduceDamageOptionHandler OPTION_HANDLER = new ReduceDamageOptionHandler();
    private final double reduceAmount;
    private final boolean isPercentage;

    public ReduceDamageOption(double amount) {
        this(amount, false);
    }

    public ReduceDamageOption(double amount, boolean isPercentage) {
        this.reduceAmount = amount;
        this.isPercentage = isPercentage;
    }

    public double getReduceAmount() {
        return this.reduceAmount;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.reduceAmount);
    }

    public static class ReduceDamageOptionHandler
    implements ISkillAbilityOptionHandler<ReduceDamageOption> {
        @Override
        public Class<ReduceDamageOption> getOptionClass() {
            return ReduceDamageOption.class;
        }

        @Override
        public void writeOption(ReduceDamageOption option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("amount", option.getReduceAmount());
            gsonMap.put("is_percentage", option.isPercentage());
        }

        @Override
        @NotNull
        public ReduceDamageOption readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            double amount = this.utilGetTypedOrThrow("amount", gsonMap, Number.class).doubleValue();
            boolean isPercentage = this.utilGetTypedOrThrow("is_percentage", gsonMap, Boolean.class);
            return new ReduceDamageOption(amount, isPercentage);
        }
    }
}

