/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.backends.server.renderer.network.DisplayParameters;
import xyz.nifeather.morph.backends.server.renderer.network.ProtocolHandler;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PlayerWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RegisterParameters;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.backends.server.renderer.utilties.WatcherUtils;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.BuildFailedException;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class ServerRenderer
extends MorphPluginObject
implements Listener {
    private final ProtocolHandler protocolHandler;
    public final RenderRegistry registry = new RenderRegistry();
    private final List<LivingEntityWatcher> livingEntityWatchers = Collections.synchronizedList(new ObjectArrayList());

    public ServerRenderer() {
        this.dependencies.cache(this.registry);
        this.protocolHandler = new ProtocolHandler();
        this.dependencies.cache(this.protocolHandler);
        this.registry.onUnRegister(this, parameters -> {
            Player player = parameters.player();
            if (player == null) {
                return;
            }
            this.unDisguiseForPlayer(player, parameters.watcher(), WatcherUtils.getAffectedPlayers(player));
        });
    }

    @Initializer
    private void load(MorphConfigManager config) {
        if (this.plugin.isEnabled()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
    }

    @EventHandler
    public void onPlayerStartUsingItem(PlayerInteractEvent event) {
        for (LivingEntityWatcher watcher : this.livingEntityWatchers) {
            watcher.onPlayerStartUsingItem(event);
        }
    }

    @Nullable
    public SingleWatcher registerEntity(Player player, EntityType entityType, String name) {
        try {
            return this.registry.register(player, new RegisterParameters(entityType, name), w -> {
                if (w instanceof LivingEntityWatcher) {
                    LivingEntityWatcher livingEntityWatcher = (LivingEntityWatcher)w;
                    this.livingEntityWatchers.add(livingEntityWatcher);
                }
            });
        }
        catch (Throwable t) {
            this.logger.error("Can't register player", t);
            this.unRegisterEntity(player);
            return null;
        }
    }

    public void unRegisterEntity(Player player) {
        try {
            SingleWatcher watcher = this.registry.unregister(player.getUniqueId());
            if (watcher != null) {
                this.livingEntityWatchers.remove(watcher);
            }
        }
        catch (Throwable t) {
            this.logger.error("Can't unregister player", t);
        }
    }

    public void refreshStateForPlayer(@Nullable Player player, List<Player> affectedPlayers) throws BuildFailedException, NullDependencyException {
        if (player == null) {
            return;
        }
        SingleWatcher watcher = this.registry.getWatcher(player.getUniqueId());
        if (watcher == null) {
            throw new NullDependencyException("Null Watcher for a existing player?!");
        }
        this.refreshStateForPlayer(player, new DisplayParameters(watcher), affectedPlayers);
    }

    public void refreshStateForPlayer(@Nullable Player player, @NotNull DisplayParameters displayParameters, List<Player> affectedPlayers) throws BuildFailedException {
        if (affectedPlayers.isEmpty()) {
            return;
        }
        if (player == null) {
            return;
        }
        SingleWatcher watcher = displayParameters.getWatcher();
        PlayerManager protocolManager = PacketEvents.getAPI().getPlayerManager();
        List<PacketWrapper<?>> spawnPackets = watcher.buildSpawnPackets();
        affectedPlayers.forEach(p -> spawnPackets.forEach(packet -> protocolManager.sendPacket(p, packet)));
    }

    public void unDisguiseForPlayer(@Nullable Player player, SingleWatcher disguiseWatcher, List<Player> affectedPlayers) {
        List<PacketWrapper<?>> packets;
        if (player == null) {
            return;
        }
        PlayerManager protocolManager = PacketEvents.getAPI().getPlayerManager();
        PlayerWatcher watcher = new PlayerWatcher(player);
        watcher.markSilent(this);
        watcher.writeEntry(CustomEntries.PROFILE, ((CraftPlayer)player).getProfile());
        watcher.writeEntry(CustomEntries.SPAWN_UUID, player.getUniqueId());
        watcher.writeEntry(CustomEntries.SPAWN_ID, player.getEntityId());
        watcher.writeEntry(CustomEntries.PROFILE_LISTED, true);
        watcher.writeEntry(CustomEntries.DONT_INCLUDE_PACKET_IDENTIFIER, true);
        try {
            packets = watcher.buildSpawnPackets();
        }
        catch (BuildFailedException e) {
            this.logger.error("PANIC! Can't undisguise player, BuildFailedException has been thrown!", (Throwable)e);
            return;
        }
        WrapperPlayServerDestroyEntities removePacket = new WrapperPlayServerDestroyEntities(player.getEntityId());
        if (disguiseWatcher.getEntityType() == EntityType.PLAYER) {
            UUID disguiseUUID = disguiseWatcher.readEntryOrThrow(CustomEntries.SPAWN_UUID);
            WrapperPlayServerPlayerInfoRemove packetRemoveInfo = new WrapperPlayServerPlayerInfoRemove(new UUID[]{disguiseUUID});
            this.featherMorph().getPlatform().onlinePlayersNative().forEach(p -> protocolManager.sendPacket(p, (PacketWrapper)packetRemoveInfo));
        }
        watcher.dispose();
        affectedPlayers.forEach(p -> {
            protocolManager.sendPacket(p, (PacketWrapper)removePacket);
            for (PacketWrapper packet : packets) {
                protocolManager.sendPacket(p, packet);
            }
        });
    }

    @Override
    public void dispose() {
        this.registry.reset();
        this.protocolHandler.dispose();
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
    }
}

