/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import org.bukkit.DyeColor;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.ShulkerProperties;

public class ShulkerWatcher
extends LivingEntityWatcher {
    public ShulkerWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.SHULKER);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.SHULKER);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        ShulkerProperties properties = DisguiseProperties.INSTANCE.getOrThrow(ShulkerProperties.class);
        if (properties.DYE_COLOR.equals(property)) {
            DyeColor val = (DyeColor)value;
            this.writePersistent(ValueIndex.SHULKER.COLOR_ID, val.getWoolData());
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId = newVal.toString();
            World world = this.getBindingPlayer().getWorld();
            switch (animId) {
                case "peek_start": {
                    this.writePersistent(ValueIndex.SHULKER.PEEK_ID, (byte)30);
                    world.playSound(this.getBindingPlayer().getLocation(), Sound.ENTITY_SHULKER_OPEN, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "open_start": {
                    this.writePersistent(ValueIndex.SHULKER.PEEK_ID, (byte)100);
                    world.playSound(this.getBindingPlayer().getLocation(), Sound.ENTITY_SHULKER_OPEN, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "peek_stop": 
                case "open_stop": {
                    this.writePersistent(ValueIndex.SHULKER.PEEK_ID, (byte)0);
                    world.playSound(this.getBindingPlayer().getLocation(), Sound.ENTITY_SHULKER_CLOSE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "reset": {
                    this.writePersistent(ValueIndex.SHULKER.PEEK_ID, (byte)0);
                    this.remove(ValueIndex.SHULKER.PEEK_ID);
                }
            }
        }
    }
}

