/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.UpdateStrings;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.updates.UpdateHandler;

public class CheckUpdateSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private UpdateHandler handler;

    @Override
    @NotNull
    public String name() {
        return "check_update";
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.check_update";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).executes(this::execute));
    }

    private int execute(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        sender.sendMessage(MessageUtils.prefixes(sender, UpdateStrings.checkingUpdate()));
        this.handler.checkUpdate(true, sender).thenAcceptAsync(result -> this.onRequestFinish((UpdateHandler.CheckResult)((Object)result), sender));
        return 1;
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return new FormattableMessage(this.plugin, "update");
    }

    private void onRequestFinish(UpdateHandler.CheckResult result, CommandSender sender) {
        switch (result) {
            case ALREADY_LATEST: {
                FormattableMessage msg = UpdateStrings.noNewVersionAvailable().resolve("mc_version", Bukkit.getMinecraftVersion());
                sender.sendMessage(MessageUtils.prefixes(sender, msg));
                break;
            }
            case FAIL: {
                FormattableMessage msg = UpdateStrings.failed();
                sender.sendMessage(MessageUtils.prefixes(sender, msg));
                break;
            }
            case NOT_LISTED_OR_UNSUPPORTED: {
                FormattableMessage msg = UpdateStrings.notListed().resolve("software", Bukkit.getName());
                sender.sendMessage(MessageUtils.prefixes(sender, msg));
                break;
            }
            case CURRENT_IS_NEWER: {
                FormattableMessage msg = UpdateStrings.currentIsNewer().resolve("mc_version", Bukkit.getMinecraftVersion());
                sender.sendMessage(MessageUtils.prefixes(sender, msg));
            }
        }
    }
}

