/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.events.gameplay.PlayerCollectMagicBottleEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerConsumeMagicBottleEvent;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.gui.AnimSelectScreenWrapper;
import xyz.nifeather.morph.misc.gui.DisguiseSelectScreenWrapper;
import xyz.nifeather.morph.shaded.inventorygui.InventoryGui;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.ItemUtils;
import xyz.nifeather.morph.utilities.PermissionUtils;

public class CustomItemRelatedEvents
extends MorphPluginObject
implements Listener {
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphs;
    public final TagKey<@NotNull EntityType> tagMagicBottleCollectable = TagKey.create((RegistryKey)RegistryKey.ENTITY_TYPE, (Key)((Key)Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:magic_bottle_collectable"))));

    @EventHandler
    public void onEntityHurtEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        Entity entity = event.getDamager();
        if (entity instanceof Player && this.invokeDisguiseTool(player = (Player)entity, Action.LEFT_CLICK_AIR, EquipmentSlot.HAND)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void disguiseToolOnPlayerInteractAtEntity(PlayerInteractAtEntityEvent e) {
        if (e.getRightClicked() instanceof ArmorStand) {
            e.setCancelled(this.invokeDisguiseTool(e.getPlayer(), Action.RIGHT_CLICK_AIR, e.getHand()) || e.isCancelled());
        }
    }

    @EventHandler
    public void disguiseToolOnPlayerInteractEntity(PlayerInteractEntityEvent e) {
        if (e.getRightClicked() instanceof InventoryHolder && e.getRightClicked().getType() != EntityType.PLAYER) {
            e.setCancelled(this.invokeDisguiseTool(e.getPlayer(), Action.RIGHT_CLICK_AIR, e.getHand()) || e.isCancelled());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (this.invokeDisguiseTool(e.getPlayer(), e.getAction(), e.getHand())) {
            e.setCancelled(true);
        }
    }

    private boolean invokeDisguiseTool(Player player, Action action, EquipmentSlot slot) {
        ItemStack mainHandItem = player.getEquipment().getItemInMainHand();
        if (mainHandItem.getType().isAir()) {
            return false;
        }
        if (!action.isLeftClick() && !action.isRightClick()) {
            return false;
        }
        DisguiseState disguiseState = this.morphs.getDisguiseStateFor(player);
        if (!ItemUtils.isDisguiseTool(mainHandItem)) {
            return false;
        }
        if (player.isSneaking()) {
            if (action.isRightClick()) {
                boolean isValidItem;
                boolean isDisguiseTool = ItemUtils.isDisguiseTool(mainHandItem);
                boolean bl = isValidItem = mainHandItem.getType() == Material.PLAYER_HEAD || isDisguiseTool;
                if (!isValidItem || action == Action.RIGHT_CLICK_BLOCK) {
                    return false;
                }
                if (!this.morphs.tryQuickDisguise(player)) {
                    if (isDisguiseTool && InventoryGui.getOpen((HumanEntity)player) == null) {
                        DisguiseSelectScreenWrapper guiScreen = new DisguiseSelectScreenWrapper(player);
                        guiScreen.show();
                    }
                    return true;
                }
                return false;
            }
            if (disguiseState == null) {
                return false;
            }
            this.morphs.unMorph(player);
        } else {
            if (disguiseState == null) {
                return false;
            }
            if (action.isRightClick()) {
                if (!disguiseState.skillInCooldown()) {
                    this.morphs.executeDisguiseSkill(player);
                }
            } else if (InventoryGui.getOpen((HumanEntity)player) == null) {
                List<String> availableAnimations = disguiseState.getProvider().getAnimationProvider().getAnimationSetFor(disguiseState.getDisguiseIdentifier()).getAvailableAnimationsForClient();
                AnimSelectScreenWrapper guiScreen = new AnimSelectScreenWrapper(disguiseState, availableAnimations);
                guiScreen.show();
            }
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        ItemStack consumedItem = event.getItem();
        String id = ItemUtils.readMagicItemData(consumedItem);
        if (id == null) {
            return;
        }
        Player player = event.getPlayer();
        PlayerConsumeMagicBottleEvent consumeMagicBottleEvent = new PlayerConsumeMagicBottleEvent(player, consumedItem);
        boolean cancelled = !consumeMagicBottleEvent.callEvent();
        boolean hasPermission = PermissionUtils.hasPermission(player, "feathermorph.magic_bottle.use", true);
        if (cancelled || !hasPermission || id.startsWith("player:") && DisguiseTypes.PLAYER.toStrippedId(id).equals(player.getName())) {
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            event.setCancelled(true);
            return;
        }
        this.morphs.grantMorphToPlayer(player, id);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void bottleOnPlayerInteractEntity(PlayerInteractEntityEvent event) {
        String disguiseIdentifier;
        Player player = event.getPlayer();
        ItemStack mainhandItem = player.getEquipment().getItem(event.getHand());
        if (!ItemUtils.isMagicItem(mainhandItem) || event.getHand() != EquipmentSlot.HAND || !player.isSneaking()) {
            return;
        }
        if (ItemUtils.readMagicItemData(mainhandItem) != null) {
            return;
        }
        Entity entityClicked = event.getRightClicked();
        PlayerCollectMagicBottleEvent collectMagicBottleEvent = new PlayerCollectMagicBottleEvent(player, entityClicked);
        boolean cancelled = !collectMagicBottleEvent.callEvent();
        boolean collectorHasPermission = PermissionUtils.hasPermission(player, "feathermorph.magic_bottle.use", true);
        Runnable failEffect = () -> {
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            player.swingHand(event.getHand());
        };
        if (cancelled || !collectorHasPermission) {
            failEffect.run();
            return;
        }
        Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENTITY_TYPE);
        if (!registry.hasTag(this.tagMagicBottleCollectable)) {
            failEffect.run();
            return;
        }
        Collection allowedTypes = registry.getTagValues(this.tagMagicBottleCollectable);
        if (!allowedTypes.contains(entityClicked.getType())) {
            failEffect.run();
            return;
        }
        Entity entity = entityClicked;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, LivingEntity.class}, (Object)entity2, n)) {
            case 0: {
                String string;
                Player playerEntity = (Player)entity2;
                if (PermissionUtils.hasPermission(playerEntity, "feathermorph.magic_bottle.exclude", false)) {
                    string = null;
                    break;
                }
                string = DisguiseTypes.PLAYER.toId(playerEntity.getName());
                break;
            }
            case 1: {
                LivingEntity livingEntity = (LivingEntity)entity2;
                String string = livingEntity.getType().key().asString();
                break;
            }
            default: {
                String string = disguiseIdentifier = null;
            }
        }
        if (disguiseIdentifier == null) {
            failEffect.run();
            return;
        }
        Entity entity3 = entityClicked;
        Objects.requireNonNull(entity3);
        Entity entity4 = entity3;
        int playerEntity = 0;
        TextComponent displayName = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, Entity.class}, (Object)entity4, playerEntity)) {
            case 0 -> {
                Player playerEntity = (Player)entity4;
                yield Component.text((String)playerEntity.getName());
            }
            default -> {
                Entity entity = entity4;
                yield Component.translatable((String)entity.getType().translationKey());
            }
        };
        ItemStack magicItem = ItemUtils.buildMagicItemFrom(ItemStack.of((Material)Material.POTION));
        ItemStack newItem = ItemUtils.writeMagicItemData(magicItem, disguiseIdentifier);
        newItem.editMeta(PotionMeta.class, arg_0 -> CustomItemRelatedEvents.lambda$bottleOnPlayerInteractEntity$1(disguiseIdentifier, (Component)displayName, arg_0));
        if (player.getGameMode() != GameMode.CREATIVE) {
            mainhandItem.setAmount(mainhandItem.getAmount() - 1);
        }
        player.give(new ItemStack[]{newItem});
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOTTLE_FILL, 1.0f, 1.0f);
        player.swingHand(event.getHand());
        event.setCancelled(true);
    }

    private static /* synthetic */ void lambda$bottleOnPlayerInteractEntity$1(String disguiseIdentifier, Component displayName, PotionMeta meta) {
        TextComponent finalLoreDisplay = (TextComponent)Component.text((String)disguiseIdentifier).style(Style.style().color(TextColor.color((int)0xAAAAAA)).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE).build());
        meta.setColor(Color.fromARGB((int)disguiseIdentifier.hashCode()));
        meta.lore(List.of(finalLoreDisplay));
        TranslatableComponent finalNameDisplay = (TranslatableComponent)Component.translatable((String)"item.morphclient.bottle_with_disguise", (String)"Magic Bottle of %s", (ComponentLike[])new ComponentLike[]{displayName}).style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE).build());
        meta.displayName((Component)finalNameDisplay);
    }
}

