/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;

public class PlayerTracker
extends MorphPluginObject
implements Listener {
    private final Map<Player, Long> lastInteractTime = new ConcurrentHashMap<Player, Long>();
    private final Map<Player, InteractType> lastInteractAction = new ConcurrentHashMap<Player, InteractType>();
    private final Map<Player, Action> lastRightClick = new Object2ObjectOpenHashMap();
    private final List<Player> duplicatedRCs = Collections.synchronizedList(new ObjectArrayList());
    private final Map<Player, Long> playerDropTrackingMap = new ConcurrentHashMap<Player, Long>();
    private final Map<Player, Long> spectatingPlayers = new ConcurrentHashMap<Player, Long>();

    public long getLastInteractTime(@Nullable Player player) {
        if (player == null) {
            return 0L;
        }
        return this.lastInteractTime.getOrDefault(player, 0L);
    }

    public boolean interactingLastTick(@Nullable Player player) {
        long current = this.plugin.getCurrentTick();
        return current - this.getLastInteractTime(player) <= 1L;
    }

    private void updateLastAction(Player player, Action action) {
        Action pl = this.lastRightClick.getOrDefault(player, null);
        this.lastRightClick.put(player, action);
        if (pl == action && action.isRightClick()) {
            this.duplicatedRCs.add(player);
        }
    }

    public boolean isDuplicatedRightClick(Player player) {
        return this.duplicatedRCs.contains(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        InteractType interactType = InteractType.fromBukkitAction(e.getAction());
        this.updateLastAction(player, e.getAction());
        if (interactType != null) {
            this.lastInteractTime.put(player, this.plugin.getCurrentTick());
            this.lastInteractAction.put(player, interactType);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamagedByEntity(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.lastInteractTime.put(player, this.plugin.getCurrentTick());
            this.lastInteractAction.put(player, InteractType.LEFT_CLICK_ENTITY);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        this.lastInteractTime.put(player, this.plugin.getCurrentTick());
        this.lastInteractAction.put(player, InteractType.RIGHT_CLICK_ENTITY);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent e) {
        Player player = e.getPlayer();
        this.updateLastAction(player, Action.RIGHT_CLICK_AIR);
        this.lastInteractTime.put(player, this.plugin.getCurrentTick());
        this.lastInteractAction.put(player, InteractType.RIGHT_CLICK_ENTITY);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDrop(PlayerDropItemEvent e) {
        Player player = e.getPlayer();
        this.playerDropTrackingMap.put(player, this.plugin.getCurrentTick());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerStartSpectate(PlayerStartSpectatingEntityEvent e) {
        Player player = e.getPlayer();
        this.spectatingPlayers.put(player, this.plugin.getCurrentTick());
        this.lastInteractTime.put(player, this.plugin.getCurrentTick());
        this.lastInteractAction.put(player, InteractType.LEFT_CLICK_ENTITY);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerStopSpectate(PlayerStopSpectatingEntityEvent e) {
        this.spectatingPlayers.remove(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (player.getSpectatorTarget() == null) {
            this.spectatingPlayers.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerExit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        this.lastInteractAction.remove(player);
        this.lastInteractTime.remove(player);
        this.playerDropTrackingMap.remove(player);
    }

    @Initializer
    private void load() {
        this.addSchedule(this::update);
    }

    public boolean playerStartingSpectating(Player player) {
        long currentTick = this.plugin.getCurrentTick();
        return player.getSpectatorTarget() != null && currentTick - this.spectatingPlayers.getOrDefault(player, currentTick) <= 0L;
    }

    public boolean interactingAnything(Player player) {
        if (!this.interactingThisTick(player)) {
            return false;
        }
        InteractType lastAction = this.getLastInteractAction(player);
        if (lastAction == null) {
            return false;
        }
        return lastAction.isInteractAnything();
    }

    public boolean interactingThisTick(Player player) {
        long tick = this.plugin.getCurrentTick();
        return tick-- - this.lastInteractTime.getOrDefault(player, tick) <= 0L;
    }

    public boolean droppingItemThisTick(Player player) {
        long tick = this.plugin.getCurrentTick();
        return tick-- - this.playerDropTrackingMap.getOrDefault(player, tick) <= 0L;
    }

    @Nullable
    public InteractType getLastInteractAction(Player player) {
        return this.lastInteractAction.get(player);
    }

    private void update() {
        this.addSchedule(this::update);
        this.lastRightClick.clear();
        this.duplicatedRCs.clear();
    }

    public static enum InteractType {
        LEFT_CLICK_AIR,
        LEFT_CLICK_ENTITY,
        LEFT_CLICK_BLOCK,
        RIGHT_CLICK_AIR,
        RIGHT_CLICK_ENTITY,
        RIGHT_CLICK_BLOCK;


        public Action toBukkitAction() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> Action.LEFT_CLICK_AIR;
                case 2 -> Action.LEFT_CLICK_BLOCK;
                case 3, 4 -> Action.RIGHT_CLICK_AIR;
                case 5 -> Action.RIGHT_CLICK_BLOCK;
            };
        }

        @Nullable
        public static InteractType fromBukkitAction(Action action) {
            return switch (action) {
                case Action.RIGHT_CLICK_AIR -> RIGHT_CLICK_AIR;
                case Action.RIGHT_CLICK_BLOCK -> RIGHT_CLICK_BLOCK;
                case Action.LEFT_CLICK_AIR -> LEFT_CLICK_AIR;
                case Action.LEFT_CLICK_BLOCK -> LEFT_CLICK_BLOCK;
                default -> null;
            };
        }

        public boolean isInteractAnything() {
            return this != RIGHT_CLICK_AIR && this != LEFT_CLICK_AIR;
        }

        public boolean isLeftClick() {
            return this == LEFT_CLICK_ENTITY || this == LEFT_CLICK_AIR || this == LEFT_CLICK_BLOCK;
        }

        public boolean isRightClick() {
            return this == RIGHT_CLICK_BLOCK || this == RIGHT_CLICK_AIR || this == RIGHT_CLICK_ENTITY;
        }
    }
}

