/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.api.networking.exceptions.OwnerDiscardedException;

public class PlayerWaitingHandler<TPlayer> {
    private final Map<TPlayer, CompletableFuture<TPlayer>> waitMap = new ConcurrentHashMap<TPlayer, CompletableFuture<TPlayer>>();

    private CompletableFuture<TPlayer> getOrCreateWaitingFuture(TPlayer player) {
        CompletableFuture existing = this.waitMap.getOrDefault(player, null);
        if (existing != null) {
            return existing;
        }
        CompletableFuture newFuture = new CompletableFuture();
        this.waitMap.put(player, newFuture);
        return newFuture;
    }

    public CompletableFuture<TPlayer> getWaitingFuture(TPlayer player) {
        return this.getOrCreateWaitingFuture(player);
    }

    public void discard(TPlayer player, @Nullable Exception reason) {
        CompletableFuture existing = this.waitMap.getOrDefault(player, null);
        if (existing != null && !existing.isDone()) {
            existing.completeExceptionally(reason != null ? reason : new OwnerDiscardedException("The parent of this waiting future has been discarded for unknown reason"));
        }
        this.waitMap.remove(player);
    }

    public void completeFuture(TPlayer player) {
        this.getOrCreateWaitingFuture(player).complete(player);
    }
}

