/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.misc.disguiseProperty.values.AbstractProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ArmorStandProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.AxolotlProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.CatProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ChickenProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.CowProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.CreeperProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.EnderDragonProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.FallbackProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.FoxProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.FrogProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.GoatProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.GuardianProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.HappyGhastProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.HoglinProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.HorseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.LlamaProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.MooshroomProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.PandaProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ParrotProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.PhantomProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.PigProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.PlayerProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.RabbitProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.SheepProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ShulkerProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.SlimeMagmaProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.SnowGolemProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.TraderLlamaProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.TropicalFishProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.VillagerProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.WolfProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZoglinProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZombieProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZombieVillagerProperties;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class DisguiseProperties {
    public static final DisguiseProperties INSTANCE = new DisguiseProperties();
    private static final Logger log = LoggerFactory.getLogger(DisguiseProperties.class);
    private final Map<EntityType, AbstractProperties<?>> handlerMap = new ConcurrentHashMap();
    private static final AbstractProperties<?> defaultProperties = new FallbackProperties();

    private DisguiseProperties() {
        this.register(EntityType.FROG, new FrogProperties());
        this.register(EntityType.CAT, new CatProperties());
        this.register(EntityType.AXOLOTL, new AxolotlProperties());
        this.register(EntityType.FOX, new FoxProperties());
        this.register(EntityType.GOAT, new GoatProperties());
        this.register(EntityType.MOOSHROOM, new MooshroomProperties());
        this.register(EntityType.PARROT, new ParrotProperties());
        this.register(EntityType.RABBIT, new RabbitProperties());
        this.register(EntityType.WOLF, new WolfProperties());
        this.register(EntityType.LLAMA, new LlamaProperties());
        this.register(EntityType.HORSE, new HorseProperties());
        this.register(EntityType.PANDA, new PandaProperties());
        this.register(EntityType.VILLAGER, new VillagerProperties());
        this.register(EntityType.ZOMBIE_VILLAGER, new ZombieVillagerProperties());
        this.register(EntityType.ARMOR_STAND, new ArmorStandProperties());
        this.register(EntityType.CREEPER, new CreeperProperties());
        this.register(EntityType.PIG, new PigProperties());
        this.register(EntityType.COW, new CowProperties());
        this.register(EntityType.CHICKEN, new ChickenProperties());
        this.register(EntityType.ENDER_DRAGON, new EnderDragonProperties());
        this.register(EntityType.HAPPY_GHAST, new HappyGhastProperties());
        this.register(EntityType.PLAYER, new PlayerProperties());
        SlimeMagmaProperties slimeMagmaProperties = new SlimeMagmaProperties();
        this.register(EntityType.SLIME, slimeMagmaProperties);
        this.register(EntityType.MAGMA_CUBE, slimeMagmaProperties);
        this.register(EntityType.SHULKER, new ShulkerProperties());
        this.register(EntityType.TRADER_LLAMA, new TraderLlamaProperties());
        this.register(EntityType.PHANTOM, new PhantomProperties());
        this.register(EntityType.SHEEP, new SheepProperties());
        this.register(EntityType.SNOW_GOLEM, new SnowGolemProperties());
        this.register(EntityType.TROPICAL_FISH, new TropicalFishProperties());
        this.register(EntityType.HOGLIN, new HoglinProperties());
        this.register(EntityType.ZOGLIN, new ZoglinProperties());
        this.register(EntityType.ZOMBIE, new ZombieProperties());
        this.register(EntityType.GUARDIAN, new GuardianProperties());
        this.register(EntityType.ELDER_GUARDIAN, new GuardianProperties());
    }

    public Map<EntityType, AbstractProperties<?>> getAll() {
        return new Object2ObjectOpenHashMap(this.handlerMap);
    }

    public void register(EntityType type, AbstractProperties<?> properties) {
        if (this.handlerMap.containsKey(type)) {
            throw new IllegalArgumentException("Already contains properties setup for type " + String.valueOf(type));
        }
        this.handlerMap.put(type, properties);
    }

    public <X> X getOrThrow(Class<X> expectedClass) {
        AbstractProperties find = this.handlerMap.values().stream().filter(expectedClass::isInstance).findFirst().orElse(null);
        if (find == null) {
            throw new NullDependencyException("Can't find '%s' in registered properties.".formatted(expectedClass));
        }
        return (X)find;
    }

    @NotNull
    public <X> X getOrThrow(EntityType type, Class<X> expetedClass) {
        AbstractProperties<?> raw = this.get(type);
        if (!expetedClass.isInstance(raw)) {
            throw new NullDependencyException("Can't get disguise properties for type '%s', expected '%s' but got '%s'".formatted(type, expetedClass, raw.getClass()));
        }
        return (X)raw;
    }

    @NotNull
    public AbstractProperties<?> get(EntityType type) {
        return this.handlerMap.getOrDefault(type, defaultProperties);
    }
}

