/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class ParseErrorException
extends Exception {
    public final String propertyName;
    public final Optional<FormattableMessage> localizableMessage;
    public final String methodName;

    public ParseErrorException(String propertyName, String msg) {
        super(msg);
        this.propertyName = propertyName;
        this.localizableMessage = Optional.empty();
        this.methodName = "";
    }

    public ParseErrorException(String propertyName, String msg, Throwable cause) {
        this(propertyName, msg, null, cause, null);
    }

    public ParseErrorException(String propertyName, String msg, @Nullable String methodName, Throwable cause, @Nullable FormattableMessage localizableMessage) {
        super(msg, cause);
        this.propertyName = propertyName;
        this.localizableMessage = Optional.ofNullable(localizableMessage);
        this.methodName = methodName == null ? "" : methodName;
    }

    public static ParseErrorGenerator forProperty(String property) {
        return new ParseErrorGenerator(property);
    }

    public static class ParseErrorGenerator {
        public final String propertyName;
        public String exceptionMessage = "unknown error (reason not given)";
        public String methodName = "";
        @Nullable
        public Throwable cause;
        @Nullable
        public FormattableMessage localizableMessage;

        public ParseErrorGenerator(String propertyName) {
            this.propertyName = propertyName;
        }

        public ParseErrorGenerator byMethod(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public ParseErrorGenerator withMessage(String msg) {
            this.exceptionMessage = msg;
            return this;
        }

        public ParseErrorGenerator causedBy(Throwable throwable) {
            this.cause = throwable;
            return this;
        }

        public ParseErrorGenerator withLocalizableMessage(FormattableMessage formattableMessage) {
            this.localizableMessage = formattableMessage;
            return this;
        }

        public ParseErrorException create() {
            String finalExceptionMessage = this.methodName.isBlank() ? this.exceptionMessage : "%s: %s".formatted(this.methodName, this.exceptionMessage);
            return new ParseErrorException(this.propertyName, finalExceptionMessage, this.methodName, this.cause, this.localizableMessage);
        }
    }
}

