/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.messages.ExceptionStrings;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.AbstractProperties;

public abstract class BaseLivingEntityProperties<E extends Entity>
extends AbstractProperties<E> {
    public final SingleProperty<Boolean> CUSTOM_NAME_VISIBLE = this.createProperty("entity/custom_name_visible", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean).withValidInput("true", "false");
    public final SingleProperty<Integer> STUCKED_ARROWS = this.createProperty("entity/stucked_arrows", 0, this::readArrows, OutputHandles::writeInteger);
    public final SingleProperty<Component> CUSTOM_NAME = this.createCustomNameProperty();
    private static final Component minimessageFormatFail = Component.text((String)"MiniMessage format error");
    private static final Component minimessageCastFail = Component.text((String)"MiniMessage cast error");

    protected SingleProperty<Component> createCustomNameProperty() {
        return this.createProperty("entity/custom_name", Component.empty(), this::readCustomNameMiniMessage, OutputHandles::writeAdventureComponentJSON);
    }

    private Optional<Component> readCustomNameMiniMessage(String propertyName, String string) throws ParseErrorException {
        if (string.length() > 256) {
            throw ParseErrorException.forProperty(propertyName).byMethod("readCustomName").withMessage("Given input is too long!").withLocalizableMessage(ExceptionStrings.inputTooLong()).create();
        }
        if (string.isBlank()) {
            throw ParseErrorException.forProperty(propertyName).byMethod("readCustomName").withMessage("Blank string for custom name").withLocalizableMessage(ExceptionStrings.noEmptyInput()).create();
        }
        Optional<Component> component = InputHandles.readAdventureComponent(propertyName, string);
        if (component.isPresent()) {
            String finalText = PlainTextComponentSerializer.plainText().serialize(component.get());
            if (finalText.length() > 50) {
                throw ParseErrorException.forProperty(propertyName).byMethod("readCustomName").withMessage("The final name input is too long!").withLocalizableMessage(ExceptionStrings.inputTooLong()).create();
            }
            if (finalText.isBlank()) {
                throw ParseErrorException.forProperty(propertyName).byMethod("readCustomName").withMessage("Blank component is not allowed").withLocalizableMessage(ExceptionStrings.noEmptyInput()).create();
            }
        }
        return component;
    }

    @Override
    protected void setupPropertiesFromEntity(PropertyHandler propertyHandler, @NotNull E targetEntity) {
        propertyHandler.set(this.CUSTOM_NAME_VISIBLE, targetEntity.isCustomNameVisible());
        Component entityCustomName = targetEntity.customName();
        if (entityCustomName != null) {
            propertyHandler.set(this.CUSTOM_NAME, entityCustomName);
        }
    }

    private Optional<Integer> readArrows(String propertyName, String string) throws ParseErrorException {
        Integer val = InputHandles.readInteger(propertyName, string).orElseThrow(() -> new ParseErrorException(propertyName, "readArrows: Unable to parse arrows"));
        InputHandles.throwIfOutOfBounds(propertyName, val, 0, 100);
        return Optional.of(val);
    }

    public BaseLivingEntityProperties() {
        this.registerSingle(this.CUSTOM_NAME, this.CUSTOM_NAME_VISIBLE, this.STUCKED_ARROWS);
    }
}

