/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal;

import com.destroystokyo.paper.entity.ai.Goal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.IGoalProvider;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphCatAvoidPlayerGoal;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphCommonMobAvoidPlayerGoal;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphOcelotAvoidPlayerGoal;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphPandaAvoidPlayerGoal;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphRabbitAvoidPlayerGoal;

public class AvoidPlayerGoals {
    private static final Map<EntityType, IGoalProvider<?>> goalProviders = new ConcurrentHashMap();

    @ApiStatus.Internal
    private static void initGoalMapping() {
        AvoidPlayerGoals.register(EntityType.CAT, MorphCatAvoidPlayerGoal.GOAL_PROVIDER);
        AvoidPlayerGoals.register(EntityType.OCELOT, MorphOcelotAvoidPlayerGoal.GOAL_PROVIDER);
        AvoidPlayerGoals.register(EntityType.RABBIT, MorphRabbitAvoidPlayerGoal.GOAL_PROVIDER);
        AvoidPlayerGoals.register(EntityType.PANDA, MorphPandaAvoidPlayerGoal.GOAL_PROVIDER);
    }

    private static void register(EntityType type, @NotNull IGoalProvider<?> provider) {
        goalProviders.put(type, provider);
    }

    public static <X extends Mob> @Nullable Goal<@NotNull X> findGoal(X mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
        IGoalProvider matchingProvider = goalProviders.getOrDefault(mob.getType(), null);
        if (matchingProvider == null) {
            matchingProvider = MorphCommonMobAvoidPlayerGoal.GOAL_PROVIDER;
        }
        IGoalProvider provider = matchingProvider;
        Goal<Mob> goal = null;
        Optional optional = provider.tryCast((Entity)mob);
        if (optional.isPresent()) {
            goal = provider.createGoal((Mob)optional.get(), morphManager, revealingHandler, detectDistance, walkSpeed, sprintSpeed);
        }
        return goal;
    }

    static {
        AvoidPlayerGoals.initGoalMapping();
    }
}

