/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.handles;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import xyz.nifeather.morph.misc.mobs.goal.handles.IEntityGoalHandle;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.CatHandle;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.CommonMobHandle;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.OcelotHandle;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.PandaHandle;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.RabbitHandle;

public class EntityGoalHandles {
    private final Map<EntityType, IEntityGoalHandle<?>> handleMap = new ConcurrentHashMap();
    public final CommonMobHandle fallbackMobHandle = new CommonMobHandle();
    private static final EntityGoalHandles instance = new EntityGoalHandles();

    public EntityGoalHandles() {
        this.initHandles();
    }

    private void initHandles() {
        this.register(EntityType.CAT, new CatHandle());
        this.register(EntityType.PANDA, new PandaHandle());
        this.register(EntityType.OCELOT, new OcelotHandle());
        this.register(EntityType.RABBIT, new RabbitHandle());
    }

    private void register(EntityType type, IEntityGoalHandle<?> handle) {
        this.handleMap.put(type, handle);
    }

    public void handle(Mob mob) {
        IEntityGoalHandle handle = this.handleMap.getOrDefault(mob.getType(), null);
        if (handle == null) {
            this.fallbackMobHandle.tryCast((Entity)mob).ifPresent(this.fallbackMobHandle::apply);
            return;
        }
        handle.tryCast((Entity)mob).ifPresent(handle::apply);
    }

    public static EntityGoalHandles instance() {
        return instance;
    }
}

