/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.handles.impl;

import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.entity.ai.PaperGoal;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.misc.mobs.goal.handles.IEntityGoalHandle;
import xyz.nifeather.morph.utilities.ReflectionUtils;

public abstract class BasicEntityHandle<M extends Mob>
implements IEntityGoalHandle<M> {
    protected final MorphManager morphManager;
    protected final RevealingHandler revealingHandler;
    protected final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();

    public BasicEntityHandle() {
        FeatherMorphAPI api = FeatherMorphAPI.instance();
        assert (api != null);
        this.morphManager = api.directAccess().morphManager();
        this.revealingHandler = api.directAccess().revealingHandler();
    }

    protected abstract Collection<com.destroystokyo.paper.entity.ai.Goal<@NotNull M>> filterGoals(M var1);

    protected abstract void onTargetGoalFound(M var1, com.destroystokyo.paper.entity.ai.Goal<@NotNull M> var2);

    @Override
    public final void apply(M mob) {
        this.addDefaultGoals(mob);
        Collection<com.destroystokyo.paper.entity.ai.Goal<M>> matchingGoals = this.filterGoals(mob);
        if (matchingGoals.isEmpty()) {
            return;
        }
        this.findAvoidPlayerGoal(matchingGoals).ifPresentOrElse(g -> this.onTargetGoalFound(mob, (com.destroystokyo.paper.entity.ai.Goal<M>)g), () -> this.whenNoTargetGoal(mob));
    }

    protected void addDefaultGoals(M mob) {
    }

    protected void whenNoTargetGoal(M mob) {
    }

    protected Optional<com.destroystokyo.paper.entity.ai.Goal<@NotNull M>> findAvoidPlayerGoal(Collection<com.destroystokyo.paper.entity.ai.Goal<@NotNull M>> collection) {
        for (com.destroystokyo.paper.entity.ai.Goal<M> g : collection) {
            AvoidEntityGoal avoidEntityGoal;
            Class clazz;
            PaperGoal paperWrapped;
            Goal goal;
            if (!(g instanceof PaperGoal) || !((goal = (paperWrapped = (PaperGoal)g).getHandle()) instanceof AvoidEntityGoal) || !(clazz = ReflectionUtils.getValue(avoidEntityGoal = (AvoidEntityGoal)goal, "avoidClass", Class.class)).isAssignableFrom(Player.class)) continue;
            return Optional.of(g);
        }
        return Optional.empty();
    }

    protected int getGoalPriority(M mob, com.destroystokyo.paper.entity.ai.Goal<@NotNull M> goal) {
        GoalSelector goalSelector = ((CraftMob)mob).getHandle().goalSelector;
        Optional<WrappedGoal> matchedGoal = goalSelector.getAvailableGoals().stream().filter(wrapped -> wrapped.getGoal().asPaperGoal().equals((Object)goal)).findFirst();
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            if (matchedGoal.isEmpty()) {
                this.logger.error("The given goal '%s' does not exist for the given mob '%s'".formatted(goal, mob));
            } else {
                this.logger.info("Given goal has priority %s for entity %s".formatted(matchedGoal.get().getPriority(), mob));
            }
        }
        return matchedGoal.map(WrappedGoal::getPriority).orElse(0);
    }

    protected MobGoals mobGoals() {
        return Bukkit.getMobGoals();
    }
}

