/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.IGoalProvider;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphBasicAvoidPlayerGoal;

public class MorphCatAvoidPlayerGoal
extends MorphBasicAvoidPlayerGoal<Cat> {
    public static final CatGoalProvider GOAL_PROVIDER = new CatGoalProvider();

    public MorphCatAvoidPlayerGoal(Cat bindingMob, RevealingHandler revealingHandler, MorphManager morphManager, double detectDistance, double walkSpeed, double sprintSpeed) {
        super(bindingMob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
    }

    @Override
    public boolean shouldActivate() {
        return !((Cat)this.mob).isTamed() && super.shouldActivate();
    }

    public GoalKey<@NotNull Cat> getKey() {
        return GoalKey.of(Cat.class, (NamespacedKey)Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:cat_avoid_player_goal")));
    }

    public static class CatGoalProvider
    implements IGoalProvider<Cat> {
        @Override
        public Optional<Cat> tryCast(Entity entity) {
            Cat cat;
            return Optional.ofNullable(entity instanceof Cat ? (cat = (Cat)entity) : null);
        }

        @Override
        public Goal<Cat> createGoal(Cat mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
            return new MorphCatAvoidPlayerGoal(mob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
        }
    }
}

