/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ocelot;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.IGoalProvider;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphBasicAvoidPlayerGoal;

public class MorphOcelotAvoidPlayerGoal
extends MorphBasicAvoidPlayerGoal<Ocelot> {
    public static final OcelotGoalProvider GOAL_PROVIDER = new OcelotGoalProvider();

    public MorphOcelotAvoidPlayerGoal(Ocelot bindingMob, RevealingHandler revealingHandler, MorphManager morphManager, double detectDistance, double walkSpeed, double sprintSpeed) {
        super(bindingMob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
    }

    public GoalKey<@NotNull Ocelot> getKey() {
        return GoalKey.of(Ocelot.class, (NamespacedKey)Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:ocelot_avoid_player_goal")));
    }

    @Override
    public boolean shouldActivate() {
        return !((Ocelot)this.mob).isTrusting() && super.shouldActivate();
    }

    public static class OcelotGoalProvider
    implements IGoalProvider<Ocelot> {
        @Override
        public Optional<Ocelot> tryCast(Entity entity) {
            Ocelot Ocelot2;
            return Optional.ofNullable(entity instanceof Ocelot ? (Ocelot2 = (Ocelot)entity) : null);
        }

        @Override
        public Goal<Ocelot> createGoal(Ocelot mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
            return new MorphOcelotAvoidPlayerGoal(mob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
        }
    }
}

