/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Rabbit;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.IGoalProvider;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphBasicAvoidPlayerGoal;

public class MorphRabbitAvoidPlayerGoal
extends MorphBasicAvoidPlayerGoal<Rabbit> {
    public static final RabbitGoalProvider GOAL_PROVIDER = new RabbitGoalProvider();

    public MorphRabbitAvoidPlayerGoal(Rabbit bindingMob, RevealingHandler revealingHandler, MorphManager morphManager, double detectDistance, double walkSpeed, double sprintSpeed) {
        super(bindingMob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
    }

    @Override
    public boolean shouldActivate() {
        return ((Rabbit)this.mob).getRabbitType() != Rabbit.Type.THE_KILLER_BUNNY && super.shouldActivate();
    }

    public GoalKey<@NotNull Rabbit> getKey() {
        return GoalKey.of(Rabbit.class, (NamespacedKey)Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:rabbit_avoid_player_goal")));
    }

    public static class RabbitGoalProvider
    implements IGoalProvider<Rabbit> {
        @Override
        public Optional<Rabbit> tryCast(Entity entity) {
            Rabbit Rabbit2;
            return Optional.ofNullable(entity instanceof Rabbit ? (Rabbit2 = (Rabbit)entity) : null);
        }

        @Override
        public Goal<Rabbit> createGoal(Rabbit mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
            return new MorphRabbitAvoidPlayerGoal(mob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
        }
    }
}

