/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.skins;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.utilities.NbtUtils;

public class SingleSkin {
    @Expose
    @SerializedName(value="name")
    public String name = "unknown";
    @Expose
    @SerializedName(value="profile")
    public String snbt = "{}";
    @Expose
    @SerializedName(value="expires_at")
    public long expiresAt;

    public static SingleSkin fromProfile(GameProfile profile) {
        SingleSkin instance = new SingleSkin();
        instance.name = profile.getName();
        instance.snbt = NbtUtils.getCompoundString(NbtUtils.toCompoundTag(profile));
        instance.expiresAt = System.currentTimeMillis() + 1296000000L;
        return instance;
    }

    @Nullable
    public GameProfile generateGameProfile() {
        if (this.snbt == null || this.snbt.equalsIgnoreCase("{}")) {
            return null;
        }
        return NbtUtils.readGameProfile(this.snbt);
    }
}

