/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.master;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.network.multiInstance.IInstanceService;
import xyz.nifeather.morph.network.multiInstance.master.InstanceServer;
import xyz.nifeather.morph.network.multiInstance.master.NetworkDisguiseManager;
import xyz.nifeather.morph.network.multiInstance.protocol.CommandRegistriesCopy;
import xyz.nifeather.morph.network.multiInstance.protocol.IInstanceClientHandler;
import xyz.nifeather.morph.network.multiInstance.protocol.MIClientboundCommandRecord;
import xyz.nifeather.morph.network.multiInstance.protocol.MIServerboundCommandRecord;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;
import xyz.nifeather.morph.network.multiInstance.protocol.ProtocolLevel;
import xyz.nifeather.morph.network.multiInstance.protocol.SocketPlayerMeta;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SLoginCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SRequestSyncCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SSyncDisguiseCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CDisconnectCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CLoginResponseCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CSwitchStateCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CSyncMetaCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CUpdateMetaCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.ProtocolState;
import xyz.nifeather.morph.network.multiInstance.slave.SlaveInstance;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class MasterInstance
extends MorphPluginObject
implements IInstanceService,
IInstanceClientHandler {
    @Nullable
    private InstanceServer bindingServer;
    @Resolved
    private MorphConfigManager config;
    private final Bindable<String> secret = new Bindable<Object>(null);
    private final Bindable<Boolean> debug_output = new Bindable<Boolean>(false);
    @Nullable
    public Runnable onStop;
    private final CommandRegistriesCopy registries = new CommandRegistriesCopy();
    private final ProtocolLevel level = ProtocolLevel.V3;
    private final Map<WebSocket, ProtocolState> allowedSockets = new Object2ObjectArrayMap();
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private final NetworkDisguiseManager disguiseManager = new NetworkDisguiseManager();
    @NotNull
    private WeakReference<SlaveInstance> slaveWeakRef = new WeakReference<Object>(null);

    private void logMasterInfo(String message) {
        this.logger.info("[Master@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logMasterWarn(String message) {
        this.logger.warn("[Master@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logMasterError(String message, Throwable t) {
        this.logger.warn("[Master@%s] %s".formatted(Integer.toHexString(this.hashCode()), message), t);
    }

    private boolean stopServer() {
        try {
            if (this.bindingServer != null) {
                this.logMasterInfo("Stopping WebSocket server...");
                this.bindingServer.stop(10000, "Master instance shutting down");
                this.bindingServer.dispose();
                this.logMasterInfo("Done stopping WebSocket server");
            }
            this.bindingServer = null;
            if (this.onStop != null) {
                this.onStop.run();
            }
            return true;
        }
        catch (Throwable t) {
            this.logMasterError("Error occurred shutting down socket server", t);
            return false;
        }
    }

    public boolean isOnline() {
        return this.bindingServer != null && this.bindingServer.running;
    }

    private boolean prepareServer() {
        if (!this.stopServer()) {
            return false;
        }
        try {
            String[] configuredAddress = this.config.getOrDefault(String.class, ConfigOption.MASTER_ADDRESS).split(":");
            String host = configuredAddress[0];
            int port = Integer.parseInt(configuredAddress.length >= 2 ? configuredAddress[1] : "39210");
            InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(host), port);
            this.bindingServer = new InstanceServer(this.plugin, addr, this);
            this.bindingServer.start();
            return true;
        }
        catch (Throwable t) {
            this.logMasterError("Error occurred while setting up server", t);
            return false;
        }
    }

    @Initializer
    private void load() {
        this.logger.info("Preparing multi-instance server...");
        this.config.bind(this.secret, ConfigOption.MASTER_SECRET);
        this.registries.registerC2S("login", MIC2SLoginCommand::fromArguments).registerC2S("dmeta", MIC2SSyncDisguiseCommand::fromArguments).registerC2S("request_meta_sync", MIC2SRequestSyncCommand::fromArguments);
        if (!this.prepareServer()) {
            this.logger.error("Can't setup server, not enabling multi-instance service!");
            return;
        }
    }

    @Override
    public boolean stop() {
        return this.stopServer();
    }

    private void onText(InstanceServer.WsRecord record) {
        WebSocket ws = record.socket();
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logMasterInfo("WS Master :: %s :: <- :: %s".formatted(ws.getRemoteSocketAddress(), record.rawMessage()));
        }
        try {
            MIServerboundCommandRecord decode = (MIServerboundCommandRecord)this.gson.fromJson(record.rawMessage(), MIServerboundCommandRecord.class);
            MIC2SCommand cmd = this.registries.createC2SCommand(decode.commandName(), decode.arguments());
            cmd.setSourceSocket(ws);
            cmd.onCommand(this);
        }
        catch (JsonSyntaxException e) {
            this.logMasterWarn("Unable to decode JSON from WebSocket '%s': %s".formatted(ws.getRemoteSocketAddress(), e.getMessage()));
            this.disconnect(ws, "Failed to decode JSON");
        }
        catch (Throwable t) {
            this.logMasterError("Error handling command from WebSocket '%s'".formatted(ws.getRemoteSocketAddress()), t);
            this.disconnect(record.socket(), "Failed to handle client message");
        }
    }

    @ApiStatus.Internal
    public void broadcastCommand(MIS2CCommand command) {
        for (WebSocket allowedSocket : this.allowedSockets.keySet()) {
            this.sendCommand(allowedSocket, command);
        }
    }

    private void sendCommand(WebSocket socket, MIS2CCommand command) {
        if (!socket.isOpen()) {
            this.logMasterWarn("Not sending commands to a closed socket! %s".formatted(socket.getRemoteSocketAddress()));
            return;
        }
        String message = this.gson.toJson((Object)MIClientboundCommandRecord.fromS2CCommand(command));
        if (this.debug_output.get().booleanValue()) {
            this.logMasterInfo("WS Master :: %s :: -> :: %s".formatted(socket.getRemoteSocketAddress(), message));
        }
        socket.send(message);
    }

    private void disconnect(WebSocket socket, String reason) {
        this.sendCommand(socket, new MIS2CDisconnectCommand(1000, reason));
        this.allowedSockets.remove(socket);
        socket.close();
    }

    private boolean socketAllowed(WebSocket socket) {
        return this.allowedSockets.getOrDefault(socket, null) != null;
    }

    private void switchState(WebSocket socket, ProtocolState state) {
        this.allowedSockets.put(socket, state);
        this.sendCommand(socket, new MIS2CSwitchStateCommand(state));
    }

    public ProtocolState getConnectionState(WebSocket socket) {
        return this.allowedSockets.getOrDefault(socket, ProtocolState.INVALID);
    }

    @Override
    public void onLoginCommand(MIC2SLoginCommand cProtocolCommand) {
        WebSocket socket = cProtocolCommand.getSocket();
        if (socket == null) {
            this.logger.info("Received a login request from an unknown source, not processing.");
            return;
        }
        this.logMasterInfo("'%s' is requesting a login".formatted(socket.getRemoteSocketAddress()));
        this.switchState(socket, ProtocolState.LOGIN);
        if (this.debug_output.get().booleanValue()) {
            this.logger.info("Level is '%s', and their secret is '%s'".formatted(cProtocolCommand.getVersion(), cProtocolCommand.getSecret()));
        }
        if (!this.level.equals(cProtocolCommand.getVersion())) {
            this.logMasterInfo("Protocol mismatch! Disconnecting...");
            this.disconnect(socket, "Protocol mismatch!");
            return;
        }
        if (cProtocolCommand.getSecret() == null || !cProtocolCommand.getSecret().equals(this.secret.get())) {
            this.logMasterInfo("Invalid secret! Disconnecting...");
            this.disconnect(socket, "Invalid secret '%s'".formatted(cProtocolCommand.getSecret()));
            return;
        }
        this.logMasterInfo("'%s' logged in".formatted(socket.getRemoteSocketAddress()));
        this.sendCommand(socket, new MIS2CLoginResponseCommand(true));
        this.switchState(socket, ProtocolState.WAIT_LISTEN);
    }

    @Override
    public void onSlaveRequestMetaSync(MIC2SRequestSyncCommand command) {
        WebSocket socket = command.getSocket();
        if (socket == null) {
            this.logger.info("Received a login request from an unknown source, not processing.");
            return;
        }
        MIS2CSyncMetaCommand cmd = new MIS2CSyncMetaCommand();
        List<PlayerMeta> disguises = this.disguiseManager.listAllMeta();
        for (PlayerMeta meta : disguises) {
            cmd.appendMeta(new SocketPlayerMeta(Operation.ADD_IF_ABSENT, meta.getUnlockedDisguiseIdentifiers(), meta.uniqueId));
        }
        this.sendCommand(socket, cmd);
        this.logMasterInfo("Synced %s metadata(s) to socket '%s'".formatted(disguises.size(), socket.getRemoteSocketAddress()));
    }

    @Override
    public void onDisguiseMetaCommand(MIC2SSyncDisguiseCommand cDisguiseMetaCommand) {
        block7: {
            PlayerMeta playerMeta;
            List<String> identifiers;
            Operation operation;
            SocketPlayerMeta socketMeta;
            block6: {
                WebSocket socket = cDisguiseMetaCommand.getSocket();
                if (!this.socketAllowed(socket)) {
                    return;
                }
                assert (socket != null);
                socketMeta = cDisguiseMetaCommand.getMeta();
                if (socketMeta == null || !socketMeta.isValid()) {
                    this.logMasterWarn("Bad client implementation? Got invalid meta from '%s'".formatted(socket.getRemoteSocketAddress()));
                    return;
                }
                ProtocolState state = this.getConnectionState(socket);
                if (!state.loggedIn()) {
                    this.logMasterWarn("Bad client implementation? They sent meta sync before they login! (%s)".formatted(socket.getRemoteSocketAddress()));
                    return;
                }
                operation = socketMeta.getOperation();
                identifiers = socketMeta.getIdentifiers();
                playerMeta = this.disguiseManager.getPlayerMeta(Bukkit.getOfflinePlayer((UUID)Objects.requireNonNull(socketMeta.getBindingUuid(), "???")));
                if (operation != Operation.ADD_IF_ABSENT) break block6;
                List<String> unlocked = playerMeta.getUnlockedDisguiseIdentifiers();
                socketMeta.getIdentifiers().forEach(str -> {
                    if (unlocked.stream().noneMatch(s -> s.equals(str))) {
                        playerMeta.addDisguise(this.disguiseManager.getDisguiseMeta((String)str));
                    }
                });
                for (WebSocket allowedSocket : this.allowedSockets.keySet()) {
                    this.sendCommand(allowedSocket, new MIS2CUpdateMetaCommand(socketMeta));
                }
                break block7;
            }
            if (operation != Operation.REMOVE) break block7;
            identifiers.forEach(id -> {
                DisguiseMeta disguiseMeta = this.disguiseManager.getDisguiseMeta((String)id);
                playerMeta.removeDisguise(disguiseMeta);
            });
            for (WebSocket allowedSocket : this.allowedSockets.keySet()) {
                this.sendCommand(allowedSocket, new MIS2CUpdateMetaCommand(socketMeta));
            }
        }
    }

    @Override
    public void onMessage(InstanceServer.WsRecord wsRecord, InstanceServer server) {
        this.addSchedule(() -> this.onText(wsRecord));
    }

    @Override
    public void onServerStart(InstanceServer server) {
    }

    @Override
    public void onConnectionClose(WebSocket socket) {
        this.allowedSockets.remove(socket);
    }

    public void setInternalSlave(SlaveInstance slave) {
        this.slaveWeakRef = new WeakReference<SlaveInstance>(slave);
    }

    public void onInternalSlaveError(SlaveInstance slave, Exception e) {
        if (e instanceof ConnectException) {
            return;
        }
        this.logger.error("Error occurred with the internal client! Stopping master server...");
        this.stop();
    }

    public void loadInitialDisguises(List<PlayerMeta> metaList) {
        this.disguiseManager.merge(metaList);
    }
}

