/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;

public class SocketPlayerMeta {
    @Expose
    @Nullable
    private Operation operation;
    @Expose
    private List<String> identifiers = new CopyOnWriteArrayList<String>();
    @Expose
    @Nullable
    private UUID uuid;
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();

    public Operation getOperation() {
        return this.operation == null ? Operation.INVALID : this.operation;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    @Nullable
    public UUID getBindingUuid() {
        return this.uuid;
    }

    public boolean isValid() {
        return this.uuid != null && this.operation != Operation.INVALID;
    }

    public SocketPlayerMeta() {
    }

    public SocketPlayerMeta(@NotNull Operation operation, List<String> ids, @NotNull UUID bindingUUID) {
        this.operation = operation;
        this.identifiers.addAll(ids);
        this.uuid = bindingUUID;
    }

    public String toString() {
        return gson.toJson((Object)this);
    }
}

