/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.slave;

import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.network.multiInstance.protocol.IMasterHandler;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public class InstanceClient
extends WebSocketClient {
    private final Logger logger;
    private final XiaMoJavaPlugin plugin;
    private final IMasterHandler masterHandler;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicBoolean connectionAlive = new AtomicBoolean(false);
    private final AtomicInteger connectionId = new AtomicInteger(0);

    public InstanceClient(URI serverUri, XiaMoJavaPlugin plugin, IMasterHandler masterHandler) {
        super(serverUri);
        this.logger = plugin.getSLF4JLogger();
        plugin.schedule(this::load);
        this.plugin = plugin;
        this.masterHandler = masterHandler;
    }

    private void load() {
    }

    private void logClientInfo(String message) {
        this.logger.info("[C@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logClientWarn(String message) {
        this.logger.warn("[C@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logClientError(String message, Throwable t) {
        this.logger.error("[C@%s] %s".formatted(Integer.toHexString(this.hashCode()), message), t);
    }

    public void dispose() {
        this.disposed.set(true);
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        this.logClientInfo("Opened connection to the instance server.");
        this.masterHandler.onConnectionOpen();
        this.connectionAlive.set(true);
    }

    @Override
    public void onMessage(String msg) {
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logger.info("Received server message: " + msg + " :: Thread is " + String.valueOf(Thread.currentThread()));
        }
        this.masterHandler.onText(msg);
    }

    @Override
    public void onClose(int code, String reason, boolean isFromRemote) {
        this.logClientInfo("Connection closed with code '%s' and reason '%s'".formatted(code, reason));
        this.connectionAlive.set(false);
        boolean shouldRetry = !reason.equalsIgnoreCase("NORETRY");
        int waitingSecond = 20;
        if (shouldRetry) {
            this.logClientInfo("Retrying connect after %s seconds...".formatted(waitingSecond));
            int connectionId = this.connectionId.incrementAndGet();
            this.plugin.schedule(() -> this.tryReconnect(connectionId), waitingSecond * 20);
        } else {
            this.logClientInfo("Not reconnecting because either the server or other sources declared NORETRY");
        }
        this.masterHandler.onConnectionClose(code);
    }

    private void tryReconnect(int connectId) {
        if (this.connectionId.get() != connectId) {
            this.logClientInfo("Not retrying because another connection is ongoing...");
            return;
        }
        this.reconnect();
    }

    @Override
    public void connect() {
        if (this.disposed.get()) {
            return;
        }
        this.logClientInfo("Connecting to the instance server...");
        if (this.connectionAlive.get()) {
            this.logClientWarn("Already connected to the server!");
            return;
        }
        this.connectionId.incrementAndGet();
        super.connect();
    }

    @Override
    public void onError(Exception e) {
        try {
            this.masterHandler.onClientError(e, this);
        }
        catch (Throwable t) {
            this.logClientError("Error occurred invoking onClientError()", t);
        }
        if (e instanceof ConnectException) {
            this.logClientInfo("Can't reach the server: " + e.getMessage());
            return;
        }
        this.logger.error("Unknown error occurred with the client %s".formatted(Integer.toHexString(this.hashCode())), (Throwable)e);
    }
}

