/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Asserts {
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @NotNull
    public static String getStringOrThrow(Map<String, String> arguments, String targetElement) throws RuntimeException {
        String val = arguments.getOrDefault(targetElement, null);
        return Objects.requireNonNull(val, "No value found for required element '%s'".formatted(targetElement));
    }

    public static List<String> getStringListOrThrow(Map<String, String> arguments, String targetElement) throws RuntimeException {
        String listString = Asserts.getStringOrThrow(arguments, targetElement);
        List<Object> rawList = ((List)gson.fromJson(listString, List.class)).stream().map(Object::toString).toList();
        return rawList;
    }
}

