/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.platform.impl.paper.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.platform.impl.paper.world.PaperLocation;
import xyz.nifeather.morph.platform.impl.paper.world.PaperWorld;
import xyz.nifeather.morph.platform.world.IPlatformLocation;
import xyz.nifeather.morph.platform.world.IPlatformWorld;
import xyz.nifeather.morph.platform.world.IPlatformWorldLookup;

public class PaperWorldLookup
implements IPlatformWorldLookup<World, Location> {
    private final Cache<World, PaperWorld> worldCache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(Duration.ofMinutes(1L)).build();

    @Override
    public PaperWorld lookup(String name) {
        World nativeWorld = Bukkit.getWorld((String)name);
        return this.getPlatformWorld(nativeWorld);
    }

    @Override
    public PaperWorld lookup(UUID uuid) {
        World nativeWorld = Bukkit.getWorld((UUID)uuid);
        return this.getPlatformWorld(nativeWorld);
    }

    public PaperWorld getPlatformWorld(World world) {
        try {
            return (PaperWorld)this.worldCache.get((Object)world, () -> new PaperWorld(world));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            FeatherMorphMain.getInstance().getSLF4JLogger().error("Failed fetching cross-platform world from cache, returning new instance.", e);
            return new PaperWorld(world);
        }
    }

    @Override
    public World getNativeWorld(IPlatformWorld platformWorld) {
        return ((PaperWorld)platformWorld).getHandle();
    }

    public PaperLocation getPlatformLocation(Location location) {
        return new PaperLocation(location.x(), location.y(), location.z(), location.getWorld());
    }

    @Override
    public Location getNativeLocation(IPlatformLocation loc) {
        World worldHandle = ((PaperLocation)loc).worldHandle();
        return new Location(worldHandle, loc.x(), loc.y(), loc.z());
    }
}

