/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.options;

import java.util.Arrays;
import java.util.Map;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class ProjectileConfiguration
implements ISkillAbilityOption {
    public static final ProjectileOptionHandler OPTION_HANDLER = new ProjectileOptionHandler();
    private final EntityType entityType;
    private final float multiplier;
    @Nullable
    private String preLaunchSoundName;
    @Nullable
    private final String soundName;
    private final int soundDistance;
    private final int distanceLimit;
    public final int executeDelay;

    public ProjectileConfiguration(EntityType entityType, float multiplier, @Nullable String soundName, int soundDistance, int distanceLimit, int executeDelay) {
        this.entityType = entityType;
        this.multiplier = multiplier;
        this.soundName = soundName;
        this.soundDistance = soundDistance;
        this.distanceLimit = distanceLimit;
        this.executeDelay = executeDelay;
    }

    public ProjectileConfiguration(EntityType entityType, float multiplier, String soundName, int soundDistance) {
        this(entityType, multiplier, soundName, soundDistance, 0);
    }

    public ProjectileConfiguration(EntityType entityType, float multiplier, @Nullable String soundName, int soundDistance, int distanceLimit) {
        this(entityType, multiplier, soundName, soundDistance, distanceLimit, 0);
    }

    public ProjectileConfiguration withWarningSound(@Nullable String soundName) {
        this.preLaunchSoundName = soundName;
        return this;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public float getVectorMultiplier() {
        return this.multiplier;
    }

    public String getPreLaunchSoundName() {
        return this.preLaunchSoundName == null ? "" : this.preLaunchSoundName;
    }

    public String getSoundName() {
        return this.soundName == null ? "" : this.soundName;
    }

    public int getSoundDistance() {
        return this.soundDistance;
    }

    public int getDistanceLimit() {
        return this.distanceLimit;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static class ProjectileOptionHandler
    implements ISkillAbilityOptionHandler<ProjectileConfiguration> {
        @Override
        public Class<ProjectileConfiguration> getOptionClass() {
            return ProjectileConfiguration.class;
        }

        @Override
        public void writeOption(ProjectileConfiguration option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("name", option.entityType().key().asString());
            gsonMap.put("speed_multiplier", Float.valueOf(option.getVectorMultiplier()));
            gsonMap.put("sound_name", option.getSoundName());
            gsonMap.put("sound_distance", option.getSoundDistance());
            gsonMap.put("warning_sound_name", option.getPreLaunchSoundName());
            gsonMap.put("max_target_distance", option.getDistanceLimit());
            gsonMap.put("delay", option.executeDelay);
        }

        @Override
        @NotNull
        public ProjectileConfiguration readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            String name = this.utilGetTypedOrThrow("name", gsonMap, String.class);
            float speedMultiplier = this.utilGetTypedOrThrow("speed_multiplier", gsonMap, Number.class).floatValue();
            String soundName = this.utilGetTypedOrNull("sound_name", gsonMap, String.class);
            int soundDistance = this.utilGetTypedOrThrow("sound_distance", gsonMap, Number.class).intValue();
            String preLaunchSoundName = this.utilGetTypedOrNull("warning_sound_name", gsonMap, String.class);
            int distanceLimit = this.utilGetTypedOrThrow("max_target_distance", gsonMap, Number.class).intValue();
            int executeDelay = this.utilGetTypedOrThrow("delay", gsonMap, Number.class).intValue();
            EntityType entityType = Arrays.stream(EntityType.values()).filter(type -> type != EntityType.UNKNOWN && type.key().asString().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new ParseErrorException(this.getClass().getSimpleName(), "No matching entity found for type '%s'".formatted(name)));
            return new ProjectileConfiguration(entityType, speedMultiplier, soundName, soundDistance, distanceLimit, executeDelay).withWarningSound(preLaunchSoundName);
        }
    }
}

