/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Mob;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.ItemUtils;

public class DisguiseUtils {
    public static int GHAST_EXECUTE_DELAY = 16;
    private static final String customDataTagName = "XIAMO_MORPH";
    private static final Map<EntityType, EntityTypeUtils.SoundInfo> typeSoundMap = new Object2ObjectArrayMap();

    public static String asString(DisguiseMeta info) {
        return info.getKey();
    }

    public static boolean validForHeadMorph(Material material) {
        return material == Material.DRAGON_HEAD || material == Material.PLAYER_HEAD || material == Material.ZOMBIE_HEAD || material == Material.SKELETON_SKULL || material == Material.WITHER_SKELETON_SKULL || material == Material.PIGLIN_HEAD;
    }

    public static List<Player> findNearbyPlayers(Player player, int distance, boolean includeSelf) {
        ObjectArrayList value = new ObjectArrayList();
        Location loc = player.getLocation();
        player.getWorld().getPlayers().forEach(p -> {
            if (p.getLocation().distance(loc) <= (double)distance) {
                value.add(p);
            }
        });
        if (!includeSelf) {
            value.remove((Object)player);
        }
        return value;
    }

    public static ItemStack[] chooseStack(ItemStack[] playerStack, ItemStack[] disguiseStack) {
        return Arrays.stream(disguiseStack).allMatch(s -> s == null || s.getType().isAir()) ? playerStack : disguiseStack;
    }

    public static ItemStack[] getHandItems(Player player) {
        EntityEquipment equipment = player.getEquipment();
        return new ItemStack[]{DisguiseUtils.itemOrAir(equipment.getItemInMainHand()), DisguiseUtils.itemOrAir(equipment.getItemInOffHand())};
    }

    public static ItemStack itemOrAir(ItemStack stack) {
        return ItemUtils.itemOrAir(stack);
    }

    public static boolean gameModeMirrorable(Player player) {
        ServerPlayerGameMode nmsPlayerMode = NmsRecord.ofPlayer((Player)player).gameMode;
        return nmsPlayerMode.isSurvival();
    }

    @NotNull
    public static EntityTypeUtils.SoundInfo getAmbientSound(DisguiseState session, EntityType bukkitType, World tickingWorld, Location tickingLocation) {
        if (bukkitType == EntityType.UNKNOWN) {
            return new EntityTypeUtils.SoundInfo(null, SoundSource.PLAYERS, Integer.MAX_VALUE, 1.0f);
        }
        EntityTypeUtils.SoundInfo cache = typeSoundMap.getOrDefault(bukkitType, null);
        if (cache != null) {
            return cache;
        }
        net.minecraft.world.entity.EntityType<?> nmsType = EntityTypeUtils.getNmsType(bukkitType);
        if (nmsType == null) {
            return new EntityTypeUtils.SoundInfo(null, SoundSource.PLAYERS, Integer.MAX_VALUE, 1.0f);
        }
        Object entity = EntityTypeUtils.createEntityThenDispose(nmsType, tickingWorld, tickingLocation);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            SoundSource source = mob.getSoundSource();
            SoundEvent sound = mob.getAmbientSound();
            int interval = mob.getAmbientSoundInterval();
            EntityTypeUtils.SoundInfo rec = new EntityTypeUtils.SoundInfo(sound, source, interval, mob.getSoundVolume());
            typeSoundMap.put(bukkitType, rec);
            return rec;
        }
        return new EntityTypeUtils.SoundInfo(null, SoundSource.PLAYERS, Integer.MAX_VALUE, 1.0f);
    }

    public static <X> X pick(List<X> list) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return list.get(random.nextInt(list.size()));
    }

    public static <X> X pick(X[] array) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return array[random.nextInt(array.length)];
    }

    static {
        typeSoundMap.put(EntityType.BEE, new EntityTypeUtils.SoundInfo(SoundEvents.BEE_LOOP, SoundSource.NEUTRAL, 120, 1.0f));
        typeSoundMap.put(EntityType.ENDER_DRAGON, new EntityTypeUtils.SoundInfo(SoundEvents.ENDER_DRAGON_AMBIENT, SoundSource.HOSTILE, 100, 5.0f));
    }
}

