/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Optional;
import java.util.SequencedSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.TooltipDisplay;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;

public class ItemUtils {
    public static final ItemStack air = new ItemStack(Material.AIR, 1);
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    public static final String MAGIC_BOTTLE_ITEM_KEY = "feathermorph:is_magic_bottle";
    public static final String MAGIC_BOTTLE_STORE_ITEM_KEY = "feathermorph:magic_bottle_store";
    public static final String SKILL_ACTIVATE_ITEM_KEY = "feathermorph:is_disguise_tool";

    public static ItemStack itemOrAir(ItemStack stack) {
        return stack == null ? air.clone() : stack;
    }

    public static ItemStack asCopy(@NotNull ItemStack stack) {
        return stack.clone();
    }

    public static ItemStack[] asCopy(ItemStack ... stacks) {
        ItemStack[] array = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack stack = stacks[i];
            array[i] = stack != null ? stack.clone() : null;
        }
        return array;
    }

    public static void extractItemCustomModel(ItemStack bukkitStack) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)bukkitStack);
        CustomModelData customModelData = (CustomModelData)nmsStack.get(DataComponents.CUSTOM_MODEL_DATA);
        if (customModelData == null) {
            return;
        }
    }

    @Nullable
    public static String getItemJsonName(ItemStack stack) {
        Component nameToSerialize;
        ItemMeta itemMeta = stack.getItemMeta();
        if (itemMeta.hasCustomName()) {
            nameToSerialize = itemMeta.customName();
        } else if (itemMeta.hasItemName()) {
            nameToSerialize = itemMeta.itemName();
        } else {
            return null;
        }
        assert (nameToSerialize != null);
        return (String)JSONComponentSerializer.json().serialize(nameToSerialize);
    }

    public static String itemToStr(ItemStack stack) {
        ItemStack item = ItemUtils.itemOrAir(stack);
        if (stack.getType().isAir()) {
            return "{\"id\":\"minecraft:air\",\"Count\":3}";
        }
        Codec nmsCodec = net.minecraft.world.item.ItemStack.CODEC;
        RegistryAccess registry = ((CraftWorld)Bukkit.getWorlds().stream().findFirst().orElseThrow()).getHandle().registryAccess();
        Optional json = nmsCodec.encodeStart((DynamicOps)registry.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)CraftItemStack.asNMSCopy((ItemStack)item)).result();
        if (json.isPresent()) {
            return gson.toJson((JsonElement)json.get());
        }
        Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
        logger.warn("Can't encode item '%s'! Providing without component data...".formatted(stack));
        return "{\"id\": \"%s\", \"Count\": 1}".formatted(stack.getType().getKey().asString());
    }

    public static ItemStack buildMagicItemFrom(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)stack);
        CustomData customData = (CustomData)nms.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            customData = CustomData.EMPTY;
        }
        customData = customData.update(tag -> tag.putBoolean(MAGIC_BOTTLE_ITEM_KEY, true));
        nms.set(DataComponents.CUSTOM_DATA, (Object)customData);
        return nms.asBukkitMirror();
    }

    public static ItemStack writeMagicItemData(ItemStack inputStack, String disguiseIdentifier) {
        net.minecraft.world.item.ItemStack nms = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)inputStack);
        CustomData customData = (CustomData)nms.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            customData = CustomData.EMPTY;
        }
        customData = customData.update(tag -> tag.putString(MAGIC_BOTTLE_STORE_ITEM_KEY, disguiseIdentifier));
        nms.set(DataComponents.CUSTOM_DATA, (Object)customData);
        nms.set(DataComponents.TOOLTIP_DISPLAY, (Object)new TooltipDisplay(false, (SequencedSet)new ObjectAVLTreeSet()));
        return nms.asBukkitMirror();
    }

    @Nullable
    public static String readMagicItemData(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)stack);
        CustomData customData = (CustomData)nms.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData == null || !customData.contains(MAGIC_BOTTLE_STORE_ITEM_KEY)) {
            return null;
        }
        return customData.copyTag().getString(MAGIC_BOTTLE_STORE_ITEM_KEY).orElse(null);
    }

    public static boolean isMagicItem(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)stack);
        CustomData customData = (CustomData)nms.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData == null || !customData.contains(MAGIC_BOTTLE_ITEM_KEY)) {
            return false;
        }
        return (Boolean)customData.copyTag().getBoolean(MAGIC_BOTTLE_ITEM_KEY).orElseThrow();
    }

    public static ItemStack buildDisguiseToolFrom(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)stack);
        CustomData customData = (CustomData)nms.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            customData = CustomData.EMPTY;
        }
        customData = customData.update(tag -> tag.putBoolean(SKILL_ACTIVATE_ITEM_KEY, true));
        nms.set(DataComponents.CUSTOM_DATA, (Object)customData);
        return nms.asBukkitMirror();
    }

    public static boolean isDisguiseTool(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)stack);
        CustomData customData = (CustomData)nms.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData == null || !customData.contains(SKILL_ACTIVATE_ITEM_KEY)) {
            return false;
        }
        return (Boolean)customData.copyTag().getBoolean(SKILL_ACTIVATE_ITEM_KEY).orElseThrow();
    }

    public static boolean isContinuousUsable(Material type) {
        return type == Material.BOW || type == Material.CROSSBOW || type == Material.TRIDENT || type == Material.SHIELD || type == Material.POTION || type == Material.MILK_BUCKET || type == Material.SPYGLASS || type.isEdible();
    }
}

