/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.BossbarOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class BossbarAbility
extends MorphAbility<BossbarOption> {
    private final Bindable<Boolean> allowBossbar = new Bindable<Boolean>(false);

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<BossbarOption> optionHandler() {
        return BossbarOption.OPTION_HANDLER;
    }

    @Initializer
    private void load(MorphConfigManager configManager) {
        configManager.bind(this.allowBossbar, ConfigOptions.DISPLAY_BOSSBAR);
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.BOSSBAR;
    }

    @Override
    public boolean revokeFromPlayer(Player player, DisguiseState state) {
        if (super.revokeFromPlayer(player, state)) {
            state.setBossbar(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean applyToPlayer(Player player, DisguiseState state) {
        if (super.applyToPlayer(player, state)) {
            if (!this.allowBossbar.get().booleanValue()) {
                return true;
            }
            BossbarOption option = (BossbarOption)this.getOptionFor(state);
            if (option == null) {
                return false;
            }
            BossbarOption.BossbarCreateOption createOption = option.getCreateOption();
            state.disguisePropertyHandler().hookOnPropertyWrite((p, v) -> this.onPropertyUpdate(state, (SingleProperty<?>)p, v));
            state.setBossbar(BossBar.bossBar((Component)this.getBossbarName(state, option), (float)1.0f, (BossBar.Color)createOption.color(), (BossBar.Overlay)createOption.overlay(), createOption.flags()));
        }
        return false;
    }

    private void onPropertyUpdate(DisguiseState state, SingleProperty<?> property, Object value) {
        if (state.disposed()) {
            return;
        }
        if (property.id().equals("entity/custom_name")) {
            this.applyToPlayer(state.getPlayer(), state);
        }
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        if (!this.isPlayerApplied(player) || this.plugin.getCurrentTick() % 4L != 0L) {
            return true;
        }
        BossbarOption option = (BossbarOption)this.getOptionFor(state);
        if (option == null) {
            return false;
        }
        BossBar bossbar = state.getBossbar();
        if (bossbar != null) {
            int distance = option.getApplyDistance();
            if (distance < 0) {
                distance = (Bukkit.getViewDistance() - 1) * 16;
            }
            GameMode playerGameMode = player.getGameMode();
            List<Player> playersToShow = DisguiseUtils.findNearbyPlayers(player, distance, true);
            ObjectArrayList playersToHide = new ObjectArrayList(this.featherMorph().getPlatform().onlinePlayersNative());
            if (playerGameMode == GameMode.SPECTATOR) {
                playersToShow.removeIf(p -> p.getGameMode() != playerGameMode);
            }
            double playerMaxHealth = Objects.requireNonNull(player.getAttribute(Attribute.MAX_HEALTH)).getValue();
            bossbar.progress((float)(player.getHealth() / playerMaxHealth));
            if (state.canDisplayBossbar()) {
                playersToHide.removeAll(playersToShow);
                playersToHide.remove(player);
            } else {
                playersToShow.clear();
            }
            playersToShow.forEach(p -> p.showBossBar(bossbar));
            playersToHide.forEach(p -> p.hideBossBar(bossbar));
        }
        return true;
    }

    private Component getBossbarName(DisguiseState state, BossbarOption option) {
        return MiniMessage.miniMessage().deserialize(option.getCreateOption().name(), new TagResolver[]{Placeholder.component((String)"name", (ComponentLike)state.getServerDisplay()), Placeholder.component((String)"who", (ComponentLike)state.getPlayer().displayName())});
    }
}

