/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.impl.NoOpOptionAbility;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.utilities.CollisionUtils;

public class SpiderAbility
extends NoOpOptionAbility {
    private final Bindable<Boolean> modifyBox = new Bindable<Boolean>(false);

    @Initializer
    private void load(MorphConfigManager config) {
        config.bind(this.modifyBox, ConfigOptions.MODIFY_BOUNDING_BOX);
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.SPIDER;
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        if (player.isInWater() || player.isSneaking()) {
            return true;
        }
        BoundingBox boundingBox = player.getBoundingBox().expand((double)0.02f, 0.0, (double)0.02f);
        boolean hasCollision = CollisionUtils.hasHardCollision(player.getWorld(), boundingBox);
        if (hasCollision) {
            Vector velocity = player.getVelocity();
            player.setVelocity(new Vector(velocity.getX(), Math.min((double)0.15f, velocity.getY() + (double)0.15f), velocity.getZ()));
        }
        return true;
    }
}

