/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.util.Vector3f;
import io.papermc.paper.math.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.SingleValue;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.ArmorStandPropertyCollection;

public class ArmorStandWatcher
extends LivingEntityWatcher {
    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.ARMOR_STAND);
    }

    public ArmorStandWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.ARMOR_STAND);
    }

    public byte getArmorStandFlags(boolean small, boolean showArms, boolean noBasePlate) {
        byte value = 0;
        if (small) {
            value = (byte)(value | 1);
        }
        if (showArms) {
            value = (byte)(value | 4);
        }
        if (noBasePlate) {
            value = (byte)(value | 8);
        }
        return value;
    }

    private boolean isSmall() {
        return (this.read(ValueIndex.ARMOR_STAND.DATA_FLAGS) & 1) == 1;
    }

    private boolean noBasePlate() {
        return (this.read(ValueIndex.ARMOR_STAND.DATA_FLAGS) & 8) == 8;
    }

    private boolean showArms() {
        return (this.read(ValueIndex.ARMOR_STAND.DATA_FLAGS) & 4) == 4;
    }

    private Vector3f getVec3(ListTag listTag, Vector3f defaultValue) {
        if (listTag.isEmpty() || listTag.size() < 3) {
            this.logger.warn("Not enough parameters in listTag! Using defaultValue...");
            return defaultValue;
        }
        return new Vector3f(((Float)listTag.getFloat(0).orElseThrow()).floatValue(), ((Float)listTag.getFloat(1).orElseThrow()).floatValue(), ((Float)listTag.getFloat(2).orElseThrow()).floatValue());
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        Rotations val;
        ArmorStandPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(ArmorStandPropertyCollection.class);
        if (property.equals(properties.SHOW_ARMS)) {
            Boolean val2 = (Boolean)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.DATA_FLAGS, this.getArmorStandFlags(this.isSmall(), val2, this.noBasePlate()));
            return;
        }
        if (property.equals(properties.HAS_BASE_PLATE)) {
            Boolean val3 = (Boolean)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.DATA_FLAGS, this.getArmorStandFlags(this.isSmall(), this.showArms(), val3 == false));
            return;
        }
        if (property.equals(properties.SMALL)) {
            Boolean val4 = (Boolean)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.DATA_FLAGS, this.getArmorStandFlags(val4, this.showArms(), this.noBasePlate()));
            return;
        }
        if (property.equals(properties.HEAD_ROTATION)) {
            val = (Rotations)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.HEAD_ROTATION, this.toVector(val));
        }
        if (property.equals(properties.BODY_ROTATION)) {
            val = (Rotations)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.BODY_ROTATION, this.toVector(val));
        }
        if (property.equals(properties.LEFT_ARM_ROTATION)) {
            val = (Rotations)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.LEFT_ARM_ROTATION, this.toVector(val));
        }
        if (property.equals(properties.RIGHT_ARM_ROTATION)) {
            val = (Rotations)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.RIGHT_ARM_ROTATION, this.toVector(val));
        }
        if (property.equals(properties.LEFT_LEG_ROTATION)) {
            val = (Rotations)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.LEFT_LEG_ROTATION, this.toVector(val));
        }
        if (property.equals(properties.RIGHT_LEG_ROTATION)) {
            val = (Rotations)value;
            this.writePersistent(ValueIndex.ARMOR_STAND.RIGHT_LEG_ROTATION, this.toVector(val));
        }
        super.onPropertyWrite(property, value);
    }

    private Vector3f toVector(Rotations rotations) {
        return new Vector3f((float)rotations.x(), (float)rotations.y(), (float)rotations.z());
    }

    private ListTag saveRotationOf(SingleValue<Vector3f> sv) {
        return this.saveRotations(this.read(sv));
    }

    private ListTag saveRotations(Vector3f rotations) {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)rotations.getX()));
        listTag.add((Object)FloatTag.valueOf((float)rotations.getY()));
        listTag.add((Object)FloatTag.valueOf((float)rotations.getZ()));
        return listTag;
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putBoolean("Small", this.isSmall());
        nbt.putBoolean("NoBasePlate", this.noBasePlate());
        nbt.putBoolean("ShowArms", this.showArms());
        CompoundTag poseCompound = new CompoundTag();
        poseCompound.put("Head", (Tag)this.saveRotationOf(ValueIndex.ARMOR_STAND.HEAD_ROTATION));
        poseCompound.put("Body", (Tag)this.saveRotationOf(ValueIndex.ARMOR_STAND.BODY_ROTATION));
        poseCompound.put("LeftArm", (Tag)this.saveRotationOf(ValueIndex.ARMOR_STAND.LEFT_ARM_ROTATION));
        poseCompound.put("RightArm", (Tag)this.saveRotationOf(ValueIndex.ARMOR_STAND.RIGHT_ARM_ROTATION));
        poseCompound.put("LeftLeg", (Tag)this.saveRotationOf(ValueIndex.ARMOR_STAND.LEFT_LEG_ROTATION));
        poseCompound.put("RightLeg", (Tag)this.saveRotationOf(ValueIndex.ARMOR_STAND.RIGHT_LEG_ROTATION));
        nbt.put("Pose", (Tag)poseCompound);
    }
}

